--
-- superSiloTrigger
--
-- MOD by Defender, edit for LS11-MP by fruktor
--

print("MapSuperSiloTrigger loaded 1.02");


MapSuperSiloTrigger = {};
MapSuperSiloTrigger.siloTriggers = {};

-- saveSelectedGame Wrapper
local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	--MapSuperSiloTrigger:saveDoorTriggerStates();
end;

function MapSuperSiloTrigger:loadMap(name)
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.mapDoorTriggers_xml = dir .. "/mapSiloTriggers.xml";
	if g_currentMission.missionInfo.isValid then
		self.firstTimeRun = true;
	else
		os.remove(self.mapDoorTriggers_xml);
		self.firstTimeRun = false;
	end;
	self.oldPlayerCount = 0;
	
	--self.fruitscount=i;
	self.actualFruit=1;
	local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.actualFruit].name);
	self.fillType = FruitUtil[key];
	--self.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[self.actualFruit].hudFruitOverlayFilename, self.baseDirectory);
	--self.fruitHud = Overlay:new("fruitHud",self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);	
	self.showHUD = false;
end;

function MapSuperSiloTrigger:deleteMap()
end;

function MapSuperSiloTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapSuperSiloTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapSuperSiloTrigger:update(dt)
	if g_server ~= nil and self.firstTimeRun then
		--self:loadSiloTriggerStates();
		self.firstTimeRun = false;
	end;
	if g_server ~= nil then
		local cnt = 0;
		for i,j in pairs(g_currentMission.players) do
			cnt = cnt + 1;
		end;
		if cnt ~= self.oldPlayerCount then
			self.oldPlayerCount = cnt;
			for i,j in pairs(self.siloTriggers) do
				g_server:broadcastEvent(MapSuperSiloTriggerEvent:new(j, j.actualFruit), nil, nil, nil);
				--print("g_server:broadcastEvent(MapSuperSiloTriggerEvent:new("..tostring(j)..", "..tostring(j.actualFruit)..", nil, nil, nil)");
			end;
		end;		
	end;

end;

function MapSuperSiloTrigger:draw()
	--[[ for i,j in pairs(self.siloTriggers) do
		if j.showHUD == true then
			if self.oldFruit ~= j.actualFruit then
				self.oldFruit = j.actualFruit;
				self.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[j.actualFruit].hudFruitOverlayFilename, self.baseDirectory);
				self.fruitHud:delete();
				self.fruitHud = Overlay:new("fruitHud", self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);		
			end;
			self.fruitHud:render();
		end;
	end; ]]--
end;

function MapSuperSiloTrigger:addSiloTrigger(siloTrigger)
	table.insert(self.siloTriggers, siloTrigger)
end;

function MapSuperSiloTrigger:setFruitType(object, fruit)	-- veraltet
	for i,j in pairs(self.siloTriggers) do
		if j == object then
			j:setActualFruit(fruit);
			break;
		end;
	end;
end;

addModEventListener(MapSuperSiloTrigger);


--
--
--

MapSuperSiloTriggerEvent = {};
MapSuperSiloTriggerEvent_mt = Class(MapSuperSiloTriggerEvent, Event);

InitEventClass(MapSuperSiloTriggerEvent, "MapSuperSiloTriggerEvent");

function MapSuperSiloTriggerEvent:emptyNew()
    local self = Event:new(MapSuperSiloTriggerEvent_mt);
    self.className="MapSuperSiloTriggerEvent";
    return self;
end;

function MapSuperSiloTriggerEvent:new(object, fruit)
    local self = MapSuperSiloTriggerEvent:emptyNew()
	self.object = object;
    self.fruit = fruit;
    return self;
end;

function MapSuperSiloTriggerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fruit = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function MapSuperSiloTriggerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.fruit);
end;

function MapSuperSiloTriggerEvent:run(connection)
	self.object:setActualFruit(self.fruit);
end;


--
--
--
--
--

function onCreate(self, id)
	local instance = SuperSiloTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

SuperSiloTrigger = {};

local SuperSiloTrigger_mt = Class(SuperSiloTrigger, Object);

function SuperSiloTrigger:new(isServer, isClient)
	local self = Object:new(isServer, isClient, SuperSiloTrigger_mt);
	self.className = "SuperSiloTrigger";
	return self;
end;

function SuperSiloTrigger:load(id)

	addTrigger(id, "superSiloTriggerCallback", self);

	self.fillSpeed = getUserAttribute(id, "fillSpeed");
	self.id = id;
  
	self.trailerInTrigger = 0;	
	self.fruitTriggerId = 0;

	self.showHud = false; 	
	self.doFill = false;
	
		
	self.fruits = {};
	local i = 0;
	for a=1, FruitUtil.NUM_FRUITTYPES do
		if (FruitUtil.fruitIndexToDesc[a].allowsSeeding) and (FruitUtil.fruitIndexToDesc[a].name~="grass") then
			i=i+1;
			self.fruits[i]=a;
			--print("Allow:"..FruitUtil.fruitIndexToDesc[a].name);
		else
			---print("Disallow:"..FruitUtil.fruitIndexToDesc[a].name);
		end;      
	end;
	self.fruitscount=i;
	self.actualFruit=1;
	
	self.siloParticleSystemRoot = loadI3DFile("data/vehicles/particleSystems/wheatParticleSystemLong.i3d");
	local x,y,z = localToWorld(self.id, -0.05, 0.15, 0.05);
	setTranslation(self.siloParticleSystemRoot, x, y, z);
	link(getRootNode(), self.siloParticleSystemRoot);

	for i=0, getNumOfChildren(self.siloParticleSystemRoot)-1 do
		local child = getChildAt(self.siloParticleSystemRoot, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					self.siloParticleSystem = geometry;
				end;
			end;
		end;
	end;

	if self.siloParticleSystem ~= nil then
		setEmittingState(self.siloParticleSystem, false);
	end;
	
	MapSuperSiloTrigger:addSiloTrigger(self);
end;

function SuperSiloTrigger:loadMap(name)  
end;

function SuperSiloTrigger:deleteMap()
end;

function SuperSiloTrigger:delete()
end;

function SuperSiloTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SuperSiloTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function SuperSiloTrigger:update(dt)
	self.showHud = false;
	
	if self.trailerInTrigger ~= 0 then	
  
		local attachable = g_currentMission.objectToTrailer[self.trailerInTrigger];
		if attachable ~= nil and attachable:getIsActiveForInput() then		
		
			local attVeh = attachable;
			local attVehBackUp = attachable;
			while true do 
				attVeh = attVeh.attacherVehicle;
				if attVeh == nil then
					break;
				else
					attVehBackUp = attVeh;
				end;
			end;
			if attVehBackUp == g_currentMission.controlledVehicle then
				self.showHud = true;
			else
				self.showHud = false;
			end;
			
			if self.showHud and
				attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then

				if InputBinding.hasEvent(InputBinding.SUPERSILO_FILL)  then
					if self.doFill then
						self:setFillState( false );
					else
						self:setFillState( true );
					end;
				end; 
				
				if self.doFill == true then
					g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STOPFILL"),InputBinding.SUPERSILO_FILL); 
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("SUPERSILO_STARTFILL"),InputBinding.SUPERSILO_FILL); 
				end;	

				--if attachable.fillLevel == 0 then
					local s = g_i18n:getText(FruitUtil.fruitIndexToDesc[self.fruits[self.actualFruit]].name);
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SUPERSILO_CHOOSEFRUIT"), s),InputBinding.IMPLEMENT_EXTRA2);
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
						self:setActualFruit(self.actualFruit+1);
					end; 
				--end;
				
			end;
			
		end;
	else
		self.doFill = false;
	end;
	
	
	if self.showHud then
		MapSuperSiloTrigger.showHUD = true;
		local s=g_i18n:getText(FruitUtil.fruitIndexToDesc[self.fruits[self.actualFruit]].name);
		if string.find(s,".xml")~=nil then              
			s=FruitUtil.fruitIndexToDesc[self.fruits[self.actualFruit]].name;
		end;
		renderText(0.66, 0.03, 0.02, s);	
	else
		MapSuperSiloTrigger.showHUD = false;
	end;		
end;

function SuperSiloTrigger:updateTick(dt)
        
	if self.trailerInTrigger ~= 0 then			
		if self.doFill then

			local realFillType = FruitUtil.fruitTypeToFillType[self.fillType];
			local fillName = Fillable.fillTypeIntToName[realFillType]; 
        		
			local attachable = g_currentMission.objectToTrailer[self.trailerInTrigger];
			if realFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
				if attachable.fillLevel < attachable.capacity and attachable:allowFillType(realFillType, true) then
					if self.doFill then
						local deltaFillLevel = dt*self.fillSpeed;
						if g_currentMission.missionStats.farmSiloAmounts[realFillType] <= deltaFillLevel then
							deltaFillLevel = g_currentMission.missionStats.farmSiloAmounts[realFillType];
							self.doFill = false;
						end;
							
						if deltaFillLevel > 0 then 	
							if g_server ~= nil then
								local fillLevel = attachable.fillLevel;
								attachable:setFillLevel(fillLevel+deltaFillLevel, realFillType);
								local newFillLevel = attachable.fillLevel;
								local siloAmount = g_currentMission:getSiloAmount(realFillType);
								g_currentMission:setSiloAmount(realFillType, math.max(siloAmount-(newFillLevel-fillLevel), 0));
							end;	
							setEmittingState(self.siloParticleSystem, true);
							
						end;
						if g_currentMission.missionStats.farmSiloAmounts[realFillType] <= 0 then
							g_currentMission.missionStats.farmSiloAmounts[realFillType] = 0;
							self.doFill = false;
						end; 									
					end;
				else
					self.doFill = false;
				end;
			else
				self.doFill = false;
			end;
		end;
	else
		self.doFill = false;
	end;
	if self.doFill == false then
	  setEmittingState(self.siloParticleSystem, false);
	end;

end;

function SuperSiloTrigger:superSiloTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if otherId ~= nil then
			self.trailerInTrigger = otherShapeId;
			self.fruitTriggerId = triggerId;
		end;		
	elseif onLeave then
		self.trailerInTrigger = 0;
		self.fruitTriggerId = 0;
		self.ShowHud = false;
	elseif onStay then
		if otherId ~= nil then
			self.trailerInTrigger = otherShapeId;
			self.fruitTriggerId = triggerId;		
		end;
	end;	
end;

function SuperSiloTrigger:setActualFruit(fruit, noEventSend)
--print("function SuperSiloTrigger:setActualFruit("..tostring(fruit)..", "..tostring(noEventSend)..")");
	SetActualFruitEvent.sendEvent(self, fruit, noEventSend);
	self.actualFruit = fruit;
	if self.actualFruit > self.fruitscount then
		self.actualFruit = 1;
	end;
	--print("self.actualFruit="..tostring(self.actualFruit));
	local key="FRUITTYPE_"..string.upper(FruitUtil.fruitIndexToDesc[self.actualFruit].name);
	self.fillType = FruitUtil[key];
	--MapSuperSiloTrigger.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[self.actualFruit].hudFruitOverlayFilename, self.baseDirectory);
	--MapSuperSiloTrigger.fruitHud = Overlay:new("fruitHud", MapSuperSiloTrigger.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);		
	--self.subHudBack = Utils.getFilename(FruitUtil.fruitIndexToDesc[self.actualFruit].hudFruitOverlayFilename, self.baseDirectory);
	--self.fruitHud:delete();
	--self.fruitHud = Overlay:new("fruitHud", self.subHudBack, 0.01, 0.01, g_currentMission.hudTipperOverlay.width, g_currentMission.hudTipperOverlay.height);		
end;


function SuperSiloTrigger:setFillState(fill, noEventSend)
--print("function SuperSiloTrigger:setFillState(fill, noEventSend)");
	SetFillStateEvent.sendEvent(self, fill, noEventSend);
	self.doFill = fill;
end;



-- 
--
-- SetFillStateEvent
-- 

SetFillStateEvent = {};
SetFillStateEvent_mt = Class(SetFillStateEvent, Event);

InitEventClass(SetFillStateEvent, "SetFillStateEvent");

function SetFillStateEvent:emptyNew()
    local self = Event:new(SetFillStateEvent_mt);
    self.className = "SetFillStateEvent";
    return self;
end;

function SetFillStateEvent:new(object, fill)
    local self = SetFillStateEvent:emptyNew()
    self.object = object;
	self.fill = fill;
    return self;
end;

function SetFillStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fill = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetFillStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.fill);
end;

function SetFillStateEvent:run(connection)
	self.object:setFillState(self.fill, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFillStateEvent:new(self.object, self.fill), nil, connection, self.object);
    end;
end;

function SetFillStateEvent.sendEvent(object, fill, noEventSend)
	if object.doFill ~= fill then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetFillStateEvent:new(object, fill), nil, nil, object);
			else
				g_client:getServerConnection():sendEvent(SetFillStateEvent:new(object, fill));
			end;
		end;
	end;
end;


-- 
--
-- SetActualFruitEvent
-- 

SetActualFruitEvent = {};
SetActualFruitEvent_mt = Class(SetActualFruitEvent, Event);

InitEventClass(SetActualFruitEvent, "SetActualFruitEvent");

function SetActualFruitEvent:emptyNew()
    local self = Event:new(SetActualFruitEvent_mt);
    self.className = "SetActualFruitEvent";
    return self;
end;

function SetActualFruitEvent:new(object, fruit)
    local self = SetActualFruitEvent:emptyNew()
    self.object = object;
	self.fruit = fruit;
    return self;
end;

function SetActualFruitEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.fruit = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetActualFruitEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.fruit);
end;

function SetActualFruitEvent:run(connection)
	self.object:setActualFruit(self.fruit, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetActualFruitEvent:new(self.object, self.fruit), nil, connection, self.object);
    end;
end;

function SetActualFruitEvent.sendEvent(object, fruit, noEventSend)
	if object.actualFruit ~= fruit then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetActualFruitEvent:new(object, fruit), nil, nil, object);
			else
				g_client:getServerConnection():sendEvent(SetActualFruitEvent:new(object, fruit));
			end;
		end;
	end;
end;

