--
-- FoldableExtension
--
--
-- @author  Manuel Leithner
-- @date  17/05/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

FoldableExtension = {};

function FoldableExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function FoldableExtension:load(xmlFile)
	self.setIsTurnedOn = Utils.appendedFunction(self.setIsTurnedOn, FoldableExtension.setIsTurnedOn);
	
	self.enableFoldAnimTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.foldingParts#enableTime"), 0);
	self.disableFoldDirection = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.foldingParts#disableDirection"), 1);
	self.turnOffInNextLoop = false;
	self.printTurnOnError = 0;
end;

function FoldableExtension:delete()
end;

function FoldableExtension:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FoldableExtension:keyEvent(unicode, sym, modifier, isDown)
end;

function FoldableExtension:update(dt)
	if self:getIsActive() then
		if self.turnOffInNextLoop then
			self:setIsTurnedOn(false, true);
			self.turnOffInNextLoop = false;
		end;
	end;
end;

function FoldableExtension:updateTick(dt)
end;

function FoldableExtension:draw()
	if self.printTurnOnError > self.time then
		g_currentMission:addWarning(string.format(g_i18n:getText("PLEASE_UNFOLD_OBJECT_FIRST"), self.typeDesc), 0.018, 0.033);
	end;
end;

function FoldableExtension:setIsTurnedOn(isTurnedOn, noEventSend)
	if isTurnedOn and self.foldAnimTime ~= nil and math.abs(self.foldAnimTime-self.enableFoldAnimTime) > 0.05 then
		self.turnOffInNextLoop = true;
		self.printTurnOnError = self.time + 2000;
	end;
end;

function FoldableExtension:setFoldDirection(direction, noEventSend)
	if direction == self.disableFoldDirection then
		self:setIsTurnedOn(false, true);
	end;
end;

