--
-- FahrAPN
-- This is the specialization for automatic bale loaders
--
-- @author  Manuel Leithner
-- @date  17/05/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

FahrAPN = {};

function FahrAPN.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function FahrAPN:load(xmlFile)
	self.rotationNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotationNodes.rotationNode(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
        if node ~= nil then
            table.insert(self.rotationNodes, {node=node, rotSpeed=rotSpeed, rotation=0});
        end;
        i = i + 1;
    end;
	
	self.ptoDummy = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerTakeoffInput#dummy"));
	self.doJointLookUp = false;
	
	self.doUpdateCount = 50;
end;

function FahrAPN:delete()
end;

function FahrAPN:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FahrAPN:keyEvent(unicode, sym, modifier, isDown)
end;

function FahrAPN:update(dt)
	if self:getIsActive() then
        if self.isTurnedOn then
			for _, node in pairs(self.rotationNodes) do
				node.rotation = (node.rotation + dt*node.rotSpeed) % (2*math.pi);
				setRotation(node.node, node.rotation, 0, 0);
			end;
			
			if not self:getIsAnimationPlaying("baling") then 
				self:playAnimation("baling", 1, nil, true);
			end;
			
			self.doUpdateCount = 50;
		end;
    end;
	
	if self.doUpdateCount > 0 then
		for _, part in pairs(self.movingParts) do
			Cylindered.updateMovingPart(self, part);
		end;
		self.doUpdateCount = self.doUpdateCount - 1;
	end;	
	
	if self.doJointLookUp then
		local implement = self.attacherVehicle:getImplementByObject(self);
		if self.attacherVehicle.ptoOutputs ~= nil then
			local ptoOutput = self.attacherVehicle.ptoOutputs[implement.jointDescIndex];
			if ptoOutput ~= nil then
				setVisibility(self.ptoDummy, false);
			end;
		end;
		self.doJointLookUp = false;
	end;
end;

function FahrAPN:draw()
end

function FahrAPN:onDetach()
	setVisibility(self.ptoDummy, true);
end;

function FahrAPN:onAttach(attacherVehicle)
	self.doJointLookUp = true;
end;

function FahrAPN:setIsTurnedOn(isTurnedOn, noEventSend)
	local animTime = nil;
	if self:getIsAnimationPlaying("baling") then
		animTime = self:getAnimationTime("baling");
	end;
	if isTurnedOn then
		self:playAnimation("baling", 1, animTime, true);
	else
		self:stopAnimation("baling", true);
	end;
end;

function FahrAPN:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local animTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#foldAnimTime"), 0);
	local foldDirection = Utils.getNoNil(getXMLInt(xmlFile, key .. "#foldDirection"), self.foldMoveDirection);

	self:playAnimation("unfold", 1, nil, true);
	self:setAnimationStopTime("unfold", animTime);
	AnimatedVehicle.updateAnimations(self, 99999999);
	
	self:setFoldDirection(foldDirection, true);
	
    return BaseMission.VEHICLE_LOAD_OK;
end

function FahrAPN:getSaveAttributesAndNodes(nodeIdent)

	local attributes = 'foldAnimTime="'..Utils.clamp(self:getAnimationTime("unfold"), 0, 1)..'" foldDirection="'.. tostring(self.foldMoveDirection) ..'"';
    local nodes = "";
	
    return attributes,nodes;
end