--
-- self
-- for all self
--
-- @author by landwirtschaftssimulator-2009.de
-- @date  08/06/09
--
-- Copyright (C) 
-- Edit Blade @date 17/12/2010


polonez = {};

function polonez.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function polonez:load(xmlFile)
      
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	local radioSound = getXMLString(xmlFile, "vehicle.radioSound#file");
    if  radioSound ~= nil and  radioSound ~= "" then
        radioSound = Utils.getFilename( radioSound, self.baseDirectory); 
        self.radioSound = createSample(" radioSound");
        self.radioSoundPlaying = false;
        loadSample(self. radioSound, radioSound, false);
        self.radioSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.radioSound#volume"),1);
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontlights = {};
    for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;	
   ---------------------------------------Blade------------------------------------
	local rotationNodedrzwiprawe1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwiprawe1#index"));
    if rotationNodedrzwiprawe1 ~= nil then
        self.drzwiprawe1 = {};
        self.drzwiprawe1.node = rotationNodedrzwiprawe1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiprawe1#minRot"));
        self.drzwiprawe1.minRot = {};
        self.drzwiprawe1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiprawe1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiprawe1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiprawe1#maxRot"));
        self.drzwiprawe1.maxRot = {};
        self.drzwiprawe1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiprawe1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiprawe1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.drzwiprawe1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiprawe1#rotTime"), 2)*1000;
        self.drzwiprawe1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiprawe1#touchRotLimit"), 10));
    end;
	local rotationNodedrzwiprawe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwiprawe#index"));
    if rotationNodedrzwiprawe ~= nil then
        self.drzwiprawe = {};
        self.drzwiprawe.node = rotationNodedrzwiprawe;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiprawe#minRot"));
        self.drzwiprawe.minRot = {};
        self.drzwiprawe.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiprawe.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiprawe.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiprawe#maxRot"));
        self.drzwiprawe.maxRot = {};
        self.drzwiprawe.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiprawe.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiprawe.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.drzwiprawe.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiprawe#rotTime"), 2)*1000;
        self.drzwiprawe.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiprawe#touchRotLimit"), 10));
    end;
	local rotationNodedrzwiLewe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwiLewe#index"));
    if rotationNodedrzwiLewe ~= nil then
        self.drzwiLewe = {};
        self.drzwiLewe.node = rotationNodedrzwiLewe;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiLewe#minRot"));
        self.drzwiLewe.minRot = {};
        self.drzwiLewe.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiLewe.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiLewe.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiLewe#maxRot"));
        self.drzwiLewe.maxRot = {};
        self.drzwiLewe.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiLewe.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiLewe.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.drzwiLewe.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiLewe#rotTime"), 2)*1000;
        self.drzwiLewe.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiLewe#touchRotLimit"), 10));
    end;
	local rotationNodedrzwiLewe1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwiLewe1#index"));
    if rotationNodedrzwiLewe1 ~= nil then
        self.drzwiLewe1 = {};
        self.drzwiLewe1.node = rotationNodedrzwiLewe1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiLewe1#minRot"));
        self.drzwiLewe1.minRot = {};
        self.drzwiLewe1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiLewe1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiLewe1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.drzwiLewe1#maxRot"));
        self.drzwiLewe1.maxRot = {};
        self.drzwiLewe1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.drzwiLewe1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.drzwiLewe1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.drzwiLewe1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiLewe1#rotTime"), 2)*1000;
        self.drzwiLewe1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.drzwiLewe1#touchRotLimit"), 10));
    end;
	local rotationPartNodebagaznik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bagaznik#index"));
    if rotationPartNodebagaznik ~= nil then
        self.bagaznik = {};
        self.bagaznik.node = rotationPartNodebagaznik;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bagaznik#minRot"));
        self.bagaznik.minRot = {};
        self.bagaznik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bagaznik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bagaznik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bagaznik#maxRot"));
        self.bagaznik.maxRot = {};
        self.bagaznik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bagaznik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bagaznik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bagaznik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bagaznik#rotTime"), 2)*1000;
        self.bagaznik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.bagaznik#touchRotLimit"), 10));
    end;
	local rotationPartNodemaska = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.maska#index"));
    if rotationPartNodemaska ~= nil then
        self.maska = {};
        self.maska.node = rotationPartNodemaska;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maska#minRot"));
        self.maska.minRot = {};
        self.maska.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.maska.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.maska.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.maska#maxRot"));
        self.maska.maxRot = {};
        self.maska.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.maska.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.maska.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.maska.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.maska#rotTime"), 2)*1000;
        self.maska.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.maska#touchRotLimit"), 10));
    end;
	------------------------Blade koniec------------------------------------------
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("HupenSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 400);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1300);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2200);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
	--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	
	self.farlightsActive = false;
    self.frontlightsActive = false;
	self.worklightsActive = false;
    self.hornPlaying = false;
    self.zuendungKey = false;
	self.allowedZuendung = false; 
end;

function polonez:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if isDown and sym == Input.KEY_l then
		self.worklightsActive = not self.worklightsActive;
		self.farlightsActive = false;
		self.frontlightsActive = false;
	end;
    if isDown and sym == Input.KEY_7 then
	    self.frontlightsActive = not self.frontlightsActive;
	    self.farlightsActive = false;
		self.worklightsActive = false;
	end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.worklightsActive = false;
	end;
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------
-----------------------------------------blade----------------------------
	if sym == Input.KEY_m then
		self.drzwiprawe1Max = isDown;
	end;
	if sym == Input.KEY_k then
		self.drzwiprawe1Min = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.drzwipraweMax = isDown;
	end;
	if sym == Input.KEY_KP_7 then
		self.drzwipraweMin = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.drzwiLeweMax = isDown;
	end;
	if sym == Input.KEY_KP_9 then
		self.drzwiLeweMin = isDown;
	end;
	if sym == Input.KEY_n then
		self.drzwiLewe1Max = isDown;
	end;
	if sym == Input.KEY_j then
		self.drzwiLewe1Min = isDown;
	end;
	if isDown and sym == Input.KEY_KP_8 then 
		self.bagaznikMax = not self.bagaznikMax;
	end; 
	if isDown and sym == Input.KEY_KP_5 then 
		self.maskaMax = not self.maskaMax;
	end; 
end;


function polonez:update(dt)
------------------------------------blade-------------------
    if self.isEntered then
	local doRotate = self.drzwipraweMax or self.drzwipraweMin 
	if self.drzwiprawe ~= nil and doRotate then
        local x, y, z = getRotation(self.drzwiprawe.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.drzwiprawe.maxRot, self.drzwiprawe.minRot, 3, self.drzwiprawe.rotTime, dt, not self.drzwipraweMax);
        setRotation(self.drzwiprawe.node, unpack(newRot));
    end;
	local doRotate = self.drzwiprawe1Max or self.drzwiprawe1Min 
	if self.drzwiprawe1 ~= nil and doRotate then
        local x, y, z = getRotation(self.drzwiprawe1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.drzwiprawe1.maxRot, self.drzwiprawe1.minRot, 3, self.drzwiprawe1.rotTime, dt, not self.drzwiprawe1Max);
        setRotation(self.drzwiprawe1.node, unpack(newRot));
    end;
	local doRotate = self.drzwiLeweMax or self.drzwiLeweMin 
	if self.drzwiLewe ~= nil and doRotate then
        local x, y, z = getRotation(self.drzwiLewe.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.drzwiLewe.maxRot, self.drzwiLewe.minRot, 3, self.drzwiLewe.rotTime, dt, not self.drzwiLeweMax);
        setRotation(self.drzwiLewe.node, unpack(newRot));
    end;
	local doRotate = self.drzwiLewe1Max or self.drzwiLewe1Min 
	if self.drzwiLewe1 ~= nil and doRotate then
        local x, y, z = getRotation(self.drzwiLewe1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.drzwiLewe1.maxRot, self.drzwiLewe1.minRot, 3, self.drzwiLewe1.rotTime, dt, not self.drzwiLewe1Max);
        setRotation(self.drzwiLewe1.node, unpack(newRot));
    end;
	if self.bagaznik ~= nil then
		local x, y, z = getRotation(self.bagaznik.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bagaznik.maxRot, self.bagaznik.minRot, 3, self.bagaznik.rotTime, dt, not self.bagaznikMax);
		setRotation(self.bagaznik.node, unpack(newRot));
    end;
	if self.maska ~= nil then
		local x, y, z = getRotation(self.maska.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.maska.maxRot, self.maska.minRot, 3, self.maska.rotTime, dt, not self.maskaMax);
		setRotation(self.maska.node, unpack(newRot));
    end;
	-------------------------blade ende---------------------------
	    if self.isEntered then
        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;
	end;
	    
		if self.isEntered then
		  if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
		for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
		end;
	end;
	end;
	end;
	
		if self.isEntered then
        if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    if not self.farlightsActive then
		for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
		end;
	end;
 end;
 
        if self.isEntered then
          if self.frontlightsActive then
            setVisibility(self.frontlights.outs, false);
          else
            setVisibility(self.frontlights.outs, true);
          end;
        end;
		
         if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.hasEvent(InputBinding.RADIO) then
             if not self.radioSoundPlaying then 
               playSample(self. radioSound, 0, self. radioSoundVolume, 0); 
               self.radioSoundPlaying = true; 
           else 
                stopSample(self. radioSound); 
                self.radioSoundPlaying = false; 
             end;  
          end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
		  
		if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.HUPE) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
    

    if not self.isAITractorActivated then
       
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.ZUENDUNG) then
		        self.zuendungKey = not self.zuendungKey;
			    self.allowedZuendung = true;
	        end;
	    end;
		
	    
	    if not self.allowedZuendung and  not self.zuendungKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	   
	    if not self.zuendungKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    
	    if self.allowedZuendung then
	        if  not self.zuendungKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedZuendung = false;	
		
			    
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.zuendungKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedZuendung = false;		
       	    end;
	    end;
   
    elseif not self.zuendungKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;


end;
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	
	
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------

end;

function polonez:draw()

    if self.isEntered then
		if not self.helpPanel then
			renderText(0.8335, 0.15, 0.02, "Taste 0: FSO Polonez Info");
		else
			renderText(0.8335, 0.15, 0.02, "Taste 0: FSO Polonez Info");
		end;
		if self.helpPanel then
			renderText(0.60, 0.84, 0.025, "- FSO Polonez 1500 'Borewicz' -");
			renderText(0.60, 0.755, 0.02, "Wcisnij NUM4/7 otworz/zamknij drzwi przednie prawe");		
			renderText(0.60, 0.785, 0.02, "Wcisnij NUM6/9 otworz/zamknij drzwi przednie lewe");
			renderText(0.60, 0.74, 0.02, "Wcisnij M/K otworz/zamknij drzwi tylne prawe");
			renderText(0.60, 0.725, 0.02, "Wcisnij N/J otworz/zamknij drzwi tylne lewe");
            renderText(0.60, 0.695, 0.02, "Wcisnij NUM5 otworz/zamknij maske");
			renderText(0.60, 0.68, 0.02, "Wcisnij NUM8 otworz/zamknij bagarznik");
			renderText(0.60, 0.665, 0.02, "Wcisnij NUM1/3|2 kierunek lewy/prawy | awaryjne");
		end;
	end;
	
    if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("Start motor"), InputBinding.ZUENDUNG);
	end;
	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Taste NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
end;

function polonez:onEnter()
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function polonez:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    self.worklightsActive = false;
	
	if self.radioSound ~= nil then
        stopSample(self.radioSound);
    end;
	
	if not self.deactivateOnLeave then
	    self.allowedZuendung = false;
	    self.zuendungKey = true; 
    else
	    self.allowedZuendung = false;
	    self.zuendungKey = false;
	end;
end;

function polonez:delete()
    delete(self.hornSoundId);
	delete(self.radioSound);
   
end;


function polonez:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;
