--
-- forog
-- Specialization for forog functionality
--
-- @author  	Alali (hazi-Modding)
-- @version 	v3.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - Changed xml-reading, added updateInterval to define updating interval for vehicles with many forog (performance issue)
--				v3.0 - added network support, changed update to updateTick
--

forog = {};

function forog.prerequisitesPresent(specializations)
    return true;
end;

function forog:load(xmlFile)
  
  
  
  self.forogNodes = {};
  
  local forogNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog#index"));
  if forogNode ~= nil then
      local speed = 0.003*3;
      table.insert(self.forogNodes, {node=forogNode, speed=speed});
  end;
  local i = 0;
  while true do
      local key = string.format("vehicle.forogs.forog(%d)", i);
      if not hasXMLProperty(xmlFile, key) then
          break;
      end;
      local forogNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
      local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
      if forogNode ~= nil then
          table.insert(self.forogNodes, {node=forogNode, speed=speed});
      end;
      i = i + 1;
  end;
  
  local rotationPartNodekar = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kar#index"));
    if rotationPartNodekar ~= nil then
        self.rotationPartkar = {};
        self.rotationPartkar.node = rotationPartNodekar;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartkar#minRot"));
        self.rotationPartkar.minRot = {};
        self.rotationPartkar.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkar.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkar.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kar#maxRot"));
        self.rotationPartkar.maxRot = {};
        self.rotationPartkar.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkar.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkar.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkar.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar#rotTime"), 2)*1000;
        self.rotationPartkar.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kar#touchRotLimit"), 10));
		
    end;
	
	local translationPartNodeSita = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.szita#index"));
    if translationPartNodeSita ~= nil then
        self.translationPartSita = {};
        self.translationPartSita.node = translationPartNodeSita;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.szita#minTrans"));
        self.translationPartSita.minTrans = {};
        self.translationPartSita.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.szita#maxTrans"));
        self.translationPartSita.maxTrans = {};
        self.translationPartSita.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPartSita.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPartSita.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPartSita.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.szita#transTime"), 2)*1000;
        self.translationPartSita.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.szita#touchTransLimit"), 10);
    end;
    
	self.szita = false;
	self.test = 100;		
end;

function forog:readStream(streamId, connection)
    
end;

function forog:writeStream(streamId, connection)
   
end;

function forog:delete()
end;

function forog:mouseEvent(posX, posY, isDown, isUp, button)
end;

function forog:keyEvent(unicode, sym, modifier, isDown)
end;

function forog:update(dt)
   
   if self.isThreshing then
 
         for _, forogNode in pairs(self.forogNodes) do
             rotate(forogNode.node, dt*forogNode.speed, 0, 0);
         end;
   end;
   if self.isThreshing and self.rotationPartkar.node ~= nil then
      
	  self.szita = not self.szita;
   end;
   if self.isThreshing and self.rotationPartkar.node ~= nil then
			
			self.rotationMaxkar = not self.rotationMaxkar;
	end;
   if self.rotationPartkar ~= nil then
		local x, y, z = getRotation(self.rotationPartkar.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkar.maxRot, self.rotationPartkar.minRot, 3, self.rotationPartkar.rotTime, dt, not self.rotationMaxkar);
		setRotation(self.rotationPartkar.node, unpack(newRot));
	end;
	if self.szita == true then
		self.test = self.test - dt;
		if self.test < 0 then
			self.translationMaxSita = not self.translationMaxSita;
			
			self.test = 100;
		end;
	end;
	
	if self.translationPartSita ~= nil then
		local x, y, z = getTranslation(self.translationPartSita.node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPartSita.maxTrans, self.translationPartSita.minTrans, 3, self.translationPartSita.transTime, dt, not self.translationMaxSita);
		setTranslation(self.translationPartSita.node, unpack(newTrans));
	end;
end;



function forog:draw()
   self.rotationMaxkar = false;
   self.szita = false;
end;
function forog:onDetach()
    self.szita = false;
	self.rotationMaxkar = false;
end;

function forog:onLeave()
    self.szita = false;
	self.rotationMaxkar = false;
end;

function forog:onDeactivate()
    self.szita = false;
	self.rotationMaxkar = false;
end;


