-- Specialization Bressel and Lade 1850 l light cargo shovel --
-- edit by Defender

multiplaneShovel = {};

function multiplaneShovel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function multiplaneShovel:load(xmlFile)
	self.fallOut = false;
	self.fallOut2 = false;
	self.implementFallOut = true;
	self.isShovel = true;
end;

function multiplaneShovel:delete()
end;

function multiplaneShovel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function multiplaneShovel:keyEvent(unicode, sym, modifier, isDown)
end;

function multiplaneShovel:update(dt)
	self.fallOut2 = false;
  if self.attacherVehicle ~= nil then
		self.fallOut2 = false;
		local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 1, 0));
		if z < 0 then
			self.fallOut = true;
		else
			self.fallOut = false;
		end;
		self.tiltangle = z;
	end;
	if self.fallOut and self.implementFallOut then
		self:setFillLevel(self.fillLevel, self.currentFillType);
		local nearestDistance = 5.0;
		local px, py, pz = getWorldTranslation(self.tipReferencePoint);
		for i=1, table.getn(g_currentMission.attachables) do
      local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];		
				if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil and attachable ~= self then
					if self.currentFillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
						if attachable.fillLevel < attachable.capacity  and self.fillLevel > 1 then							
							local deltaLevel = (self.tiltangle*self.tiltangle)*(self.capacity/200)*dt							
							local fillDelta = math.min(deltaLevel, self.fillLevel)
							self:setFillLevel(self.fillLevel - fillDelta, self.currentFillType);
							attachable:setFillLevel(attachable.fillLevel + fillDelta, self.currentFillType);
							self.fallOut2 = self.fillLevel>0 and fillDelta>0;						
						end; 
					end;
				end;
			end;
		end;		
	end;
	Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], self.fallOut2);
end;

function multiplaneShovel:draw()
end;

function multiplaneShovel:onDetach()
    if self.deactivateOnDetach then
        multiplaneShovel.onDeactivate(self);
    end;
end;

function multiplaneShovel:onDeactivate()
    self.fallOut = false;
end;
