--
-- Rotation
-- Specialization for all the user-controlled rotating parts on a vehicle
--
-- @author  Templaer
-- @date  19/11/09
--

Rotation = {};

function Rotation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Rotation:load(xmlFile)
	self.doRotate = SpecializationUtil.callSpecializationsFunction("doRotate");

    self.rotatingParts = {};
    local rotatingPartsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rotatingParts#count"), 0);	
	for i=1, rotatingPartsCount do
		local namei = string.format("vehicle.rotatingParts.rotatingPart%d", i);
		local rotatingPart = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
		
		self.rotatingParts[i] = {};
		self.rotatingParts[i].node = rotatingPart;
		
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#minRot"));
        self.rotatingParts[i].minRot = {};
        self.rotatingParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, namei .. "#maxRot"));
		self.rotatingParts[i].maxRot = {};
        self.rotatingParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotatingParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotatingParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		
		self.rotatingParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile, namei .. "#rotTime"), 2)*1000;
	end;
	
	self.isLeftDoorOpen = false;
	self.isRightDoorOpen = false;
	self.isRearWindowOpen = false;
	self.isFrontWindowOpen = false;
end;

function Rotation:delete()
end;

function Rotation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rotation:keyEvent(unicode, sym, modifier, isDown)
end;

function Rotation:update(dt)	
    if self.isEntered then
		if self.rotatingParts[1] ~= nil then
			if InputBinding.hasEvent(InputBinding.LEFTDOOR) then
				self.isLeftDoorOpen = not self.isLeftDoorOpen;
			end;
			
			self:doRotate(1, self.isLeftDoorOpen, dt);	
		end;
		
		if self.rotatingParts[2] ~= nil then
			if InputBinding.hasEvent(InputBinding.RIGHTDOOR) then	
				self.isRightDoorOpen = not self.isRightDoorOpen;
			end;
			
			self:doRotate(2, self.isRightDoorOpen, dt);
		end;
		
		if self.rotatingParts[3] ~= nil then		
			if InputBinding.hasEvent(InputBinding.REARWINDOW) then	
				self.isRearWindowOpen = not self.isRearWindowOpen;
			end;
		
			self:doRotate(3, self.isRearWindowOpen, dt);
		end;
		
		if self.rotatingParts[4] ~= nil then
			if InputBinding.hasEvent(InputBinding.FRONTWINDOW) then	
				self.isFrontWindowOpen = not self.isFrontWindowOpen;
			end;
			
			self:doRotate(4, self.isFrontWindowOpen, dt);
		end;
	end;
end;

-- Additional function(s)
function Rotation:doRotate(index, boolean, dt)
	local x, y, z = getRotation(self.rotatingParts[index].node);
	local rot = {x,y,z};
	local newRot = Utils.getMovedLimitedValues(rot, self.rotatingParts[index].maxRot, self.rotatingParts[index].minRot, 3, self.rotatingParts[index].rotTime, dt, not boolean);
	setRotation(self.rotatingParts[index].node, unpack(newRot));
end;

function Rotation:draw()
	
end;
