adblueChangeEvent = {};
adblueChangeEvent_mt = Class(adblueChangeEvent, Event);

InitEventClass(adblueChangeEvent, "adblueChangeEvent");

function adblueChangeEvent:emptyNew()
    local self = Event:new(adblueChangeEvent_mt);
    self.className="adblueChangeEvent";
    return self;
end;

function adblueChangeEvent:new(vehicle, adblueChangeVehicle)
    local self = adblueChangeEvent:emptyNew()
    self.vehicle = vehicle;
	self.adblueChangeVehicle = adblueChangeVehicle;
    return self;
end;

function adblueChangeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.adblueChangeVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function adblueChangeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.adblueChangeVehicle));
end;

function adblueChangeEvent:run(connection)
	self.vehicle:changeadblue(self.adblueChangeVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(adblueChangeEvent:new(self.vehicle, self.adblueChangeVehicle), nil, connection, self.object);
    end;
end;


function adblueChangeEvent.sendEvent(vehicle, adblueChangeVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(adblueChangeEvent:new(vehicle, adblueChangeVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(adblueChangeEvent:new(vehicle, adblueChangeVehicle));
		end;
	end;
end;
