BuyabletwinWheightAttachEvent = {};
BuyabletwinWheightAttachEvent_mt = Class(BuyabletwinWheightAttachEvent, Event);

InitEventClass(BuyabletwinWheightAttachEvent, "BuyabletwinWheightAttachEvent");

function BuyabletwinWheightAttachEvent:emptyNew()
    local self = Event:new(BuyabletwinWheightAttachEvent_mt);
    self.className="BuyabletwinWheightAttachEvent";
    return self;
end;

function BuyabletwinWheightAttachEvent:new(vehicle, attacherVehicle)
    local self = BuyabletwinWheightAttachEvent:emptyNew()
    self.vehicle = vehicle;
	self.attacherVehicle = attacherVehicle;
    return self;
end;

function BuyabletwinWheightAttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.attacherVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyabletwinWheightAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.attacherVehicle));
end;

function BuyabletwinWheightAttachEvent:run(connection)
	self.vehicle:assembleWheels(self.attacherVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyabletwinWheightAttachEvent:new(self.vehicle, self.attacherVehicle), nil, connection, self.object);
    end;
end;


function BuyabletwinWheightAttachEvent.sendEvent(vehicle, attacherVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyabletwinWheightAttachEvent:new(vehicle, attacherVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyabletwinWheightAttachEvent:new(vehicle, attacherVehicle));
		end;
	end;
end;