BuyabletwinWheightDetachEvent = {};
BuyabletwinWheightDetachEvent_mt = Class(BuyabletwinWheightDetachEvent, Event);

InitEventClass(BuyabletwinWheightDetachEvent, "BuyabletwinWheightDetachEvent");

function BuyabletwinWheightDetachEvent:emptyNew()
    local self = Event:new(BuyabletwinWheightDetachEvent_mt);
    self.className="BuyabletwinWheightDetachEvent";
    return self;
end;

function BuyabletwinWheightDetachEvent:new(vehicle)
    local self = BuyabletwinWheightDetachEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function BuyabletwinWheightDetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyabletwinWheightDetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
end;

function BuyabletwinWheightDetachEvent:run(connection)
	self.vehicle:disassembleWheels(true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyabletwinWheightDetachEvent:new(self.vehicle), nil, connection, self.object);
    end;
end;


function BuyabletwinWheightDetachEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyabletwinWheightDetachEvent:new(vehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyabletwinWheightDetachEvent:new(vehicle));
		end;
	end;
end;