--
-- adbluePallet
-- Specialization for adblue change
--
-- @author  	JoXXer
-- @version 	v1.0
-- @date  		16/11/11
-- @history:	v1.0 - Initial version
--

adbluePallet = {};

function adbluePallet.prerequisitesPresent(specializations)
    return true;
end;

function adbluePallet:load(xmlFile)

	self.changeadblue = SpecializationUtil.callSpecializationsFunction("changeadblue");

	self.adbluePalletTriggerCallback = adbluePallet.adbluePalletTriggerCallback;

	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.adbluePallet#checkString"), "adblueChange")
	self.usingTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.adbluePallet#activationTrigger"));


	addTrigger(self.usingTrigger, "adbluePalletTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.usingTrigger, "adblueDelete", self);

	self.adbluePalletVehicle = nil;
	self.adblueCapacity = 400;
end;

function adbluePallet:delete()
    removeTrigger(self.usingTrigger);
end;

function adbluePallet:wheelDelete()
    removeDeleteListener(self.usingTrigger, self.deleteListenerId);
end;

function adbluePallet:readStream(streamId, connection)
	self.adblueCapacity = streamReadInt16(streamId);
end;

function adbluePallet:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.adblueCapacity);
end;

function adbluePallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function adbluePallet:keyEvent(unicode, sym, modifier, isDown)
end;

function adbluePallet:update(dt)
end;

function adbluePallet:updateTick(dt)

end;

function adbluePallet:draw()
end;

function adbluePallet:adbluePalletTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	local vehicle = g_currentMission.controlledVehicle;
	if vehicle ~= nil then
		if onEnter or onStay then
			if vehicle.rootNode == otherId then
				if vehicle.adblueChange ~= nil then
					if vehicle.adblueChange.checkString == self.checkString then
						if self.adbluePalletVehicle ~= nil then
							if self.adbluePalletVehicle == vehicle then
								vehicle.adblueChange.adblueInRange = self;
							end;
						else
							vehicle.adblueChange.adblueInRange = self;
						end;
					end;
				end;
			end;
		elseif onLeave then
			if otherId == vehicle.rootNode then
				if vehicle.adblueChange ~= nil then
					vehicle.adblueChange.adblueInRange = nil;
				end;
			end;
		end;
	end;
end;

function adbluePallet:changeadblue(vehicle, noEventSend)
	adblueChangeEvent.sendEvent(self, vehicle, noEventSend);

	if vehicle.adblueChange ~= nil then
		self.adbluePalletVehicle = vehicle;
		self.adbluePalletVehicle:changeadblue(self);
	end;
end;

function adbluePallet:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#adblueCapacity");
		if valueInt ~= nil then
			self.adblueCapacity = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function adbluePallet:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'adblueCapacity="'.. self.adblueCapacity .. '"';

	return attributes, nil;
end;




