--
-- adblueChange
-- Specialization for changing adblue
--
-- @author	JoXXer
-- @date  	16/11/11
--

adblueChange = {};

function adblueChange.prerequisitesPresent(specializations)
    return true;
end;

function adblueChange:load(xmlFile)

	self.changeadblue = SpecializationUtil.callSpecializationsFunction("changeadblue");

	self.adblueChange = {};
	self.adblueChange.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.adblueChange#adblueChangeCheckString"), "adblueChange");
	self.adblueChange.adblueInRange = nil;


	self.shouldChangeadblue = false;
	self.nextadblueChange = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.adblueChange#firstadblueChange"), 200)
	self.adblueChangeInterval = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.adblueChange#interval"), 200)

	self.checkadblueOverlay = Overlay:new("hudcheckadblueOverlay", Utils.getFilename("textur/CheckEngineadblue.png", self.baseDirectory), 0.915, 0.22, 0.03125, 0.05);
end;

function adblueChange:delete()

end;

function adblueChange:readStream(streamId, connection)
    self.shouldChangeadblue = streamReadBool(streamId);
    self.nextadblueChange = streamReadInt32(streamId);
end;

function adblueChange:writeStream(streamId, connection)
    streamWriteBool(streamId, self.shouldChangeadblue);
    streamWriteInt32(streamId, self.nextadblueChange);
end;

function adblueChange:mouseEvent(posX, posY, isDown, isUp, button)
end;

function adblueChange:keyEvent(unicode, sym, modifier, isDown)
end;

function adblueChange:update(dt)
	if self:getIsActive() then

		local adblueChange = self.adblueChange;
		local adblueWarning = (self.nextadblueChange * 200) * 0.9;

		if adblueChange.adblueInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CHANGE_adblue) then
					if adblueWarning < self.operatingTime and adblueChange.adblueInRange.adblueCapacity >= 10 then
						adblueChange.adblueInRange:changeadblue(self);
					end;
				end;
				if adblueChange.adblueInRange.adblueCapacity == 0 then
					g_currentMission:addWarning(g_i18n:getText("Out_Of_adblue") .. "\n" .. g_i18n:getText("Buy_More_adblue"));
				end;
			end;
		end;

		

		if self.isMotorStarted then
			if adblueWarning < self.operatingTime then
				setVisibility(self.adblueLight, true);
			else
				setVisibility(self.adblueLight, false);
			end;
		end;
		if self.ignitionMode == 0 and self.ignitionMode ~= nil then
			setVisibility(self.adblueLight, false)
		end;
	end;
end;

function adblueChange:draw()
	local adblueChange = self.adblueChange;
	local adblueWarning = (self.nextadblueChange * 200) * 0.9;

	if adblueChange.adblueInRange ~= nil then
		if adblueWarning < self.operatingTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("CHANGE_adblue"), InputBinding.CHANGE_adblue);

		end;
	end;

	if adblueWarning < self.operatingTime then
		self.checkadblueOverlay:render();
	end;

	

end;

function adblueChange:changeadblue(adblueChange)
	if adblueChange.adbluePalletVehicle ~= nil then
		adblueChange.adblueCapacity = adblueChange.adblueCapacity - 10;
		self.shouldChangeadblue = false;
		self.nextadblueChange = self.nextadblueChange + self.adblueChangeInterval;
	end;
end;

function adblueChange:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#nextadblueChange");
		if valueInt ~= nil then
			self.nextadblueChange = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function adblueChange:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'nextadblueChange="'.. self.nextadblueChange .. '"';

	return attributes, nil;
end;
