--
-- Einblendungs .lua -- Set Blends 1
-- Specialization for Einblendung
--
-- www.LS-Landtechnik.de
-- @author  LS-Landtechnik.de
-- @date:		01/01/11
-- @version:	v2.0
-- @copyright:	LS-Landtechnik.de



Setblends1Event = {};
Setblends1Event_mt = Class(Setblends1Event, Event);
InitEventClass(Setblends1Event, "Setblends1Event");
function Setblends1Event:emptyNew()
      local self = Event:new(Setblends1Event_mt);
      self.className="Setblends1Event";
      return self;
end;
function Setblends1Event:new(object, active)
      local self = Setblends1Event:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function Setblends1Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function Setblends1Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function Setblends1Event:run(connection)
      self.object:setblends1Visibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(Setblends1Event:new(self.object, self.active), nil, connection, self.object);
      end;
end;