--
-- EnterAnimation
-- Specialization for Enter Animation
--
-- @author  JoXXer
-- @date  21/09/11
--

EnterAnimation = {};

function EnterAnimation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function EnterAnimation:load(xmlFile)
	-- Functions
	self.skipAnimation = SpecializationUtil.callSpecializationsFunction("skipAnimation");

	-- onEnter Animation
	self.onEnterAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onEnter#rootNode"));
    self.onEnterAnimCharSet = 0;
    if self.onEnterAnimRootNode ~= nil and self.onEnterAnimRootNode ~= 0 then
        self.onEnterAnimCharSet = getAnimCharacterSet(self.onEnterAnimRootNode);
        if self.onEnterAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.onEnterAnimCharSet, getXMLString(xmlFile, "vehicle.onEnter#clip"));
            assignAnimTrackClip(self.onEnterAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.onEnterAnimCharSet, 0, false);
            local onEnterAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.onEnter#speedScale"), 1);
			setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, onEnterAnimSpeedScale);
            self.onEnterAnimDuration = getAnimClipDuration(self.onEnterAnimCharSet, clip);
        end;
    end;

	--VARIABLEs
	self.hasPlayedOnEnter = true;
	self.hasOpenedDoor = false;
	self.hasEntered = false;
end;

function EnterAnimation:delete()
end;

function EnterAnimation:readStream(streamId, connection)

end;

function EnterAnimation:writeStream(streamId, connection)

end;

function EnterAnimation:readUpdateStream(streamId, timestamp, connection)

end;

function EnterAnimation:writeUpdateStream(streamId, connection, dirtyMask)

end;

function EnterAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function EnterAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function EnterAnimation:update(dt)
	if self.hasPlayedOnEnter == false then
		if self.hasOpenedDoor == false then
			if self.interactiveObjects[5].isOpen == false then
				self.interactiveObjects[5].isOpen = true;
				if self.interactiveObjects[5].animation.animCharSet ~= 0 then
					if getAnimTrackTime(self.interactiveObjects[5].animation.animCharSet, 0) < 0.0 then
						setAnimTrackTime(self.interactiveObjects[5].animation.animCharSet, 0, 0.0);
					end;
					setAnimTrackSpeedScale(self.interactiveObjects[5].animation.animCharSet, 0, self.interactiveObjects[5].animation.animSpeedScale);
					enableAnimTrack(self.interactiveObjects[5].animation.animCharSet, 0);
				end;
			end;
			if getAnimTrackTime(self.interactiveObjects[5].animation.animCharSet, 0) > self.interactiveObjects[5].animation.animDuration then
				self.hasOpenedDoor = true;
			end;
		end;

		if self.hasOpenedDoor then
			if self.onEnterAnimCharSet ~= 0 then
				if getAnimTrackTime(self.onEnterAnimCharSet, 0) < 0.0 then
					setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
				end;
				setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, 1);
				enableAnimTrack(self.onEnterAnimCharSet, 0);
			end;
			if getAnimTrackTime(self.onEnterAnimCharSet, 0) > self.onEnterAnimDuration then
				self.hasEntered = true;
			end;
		end;

		if self.hasEntered then
			self.interactiveObjects[5].isOpen = false;
			if self.interactiveObjects[5].animation.animCharSet ~= 0 then
				if getAnimTrackTime(self.interactiveObjects[5].animation.animCharSet, 0) > self.interactiveObjects[5].animation.animDuration then
					setAnimTrackTime(self.interactiveObjects[5].animation.animCharSet, 0, self.interactiveObjects[5].animation.animDuration);
				end;
				setAnimTrackSpeedScale(self.interactiveObjects[5].animation.animCharSet, 0, -self.interactiveObjects[5].animation.animSpeedScale);
				enableAnimTrack(self.interactiveObjects[5].animation.animCharSet, 0);
			end;
			self.hasPlayedOnEnter = true;
		end;
		if InputBinding.hasEvent(InputBinding.SKIP_ENTER_ANIMATION) then
			self:skipAnimation();
		end;
	end;
end;

function EnterAnimation:updateTick(dt)
end;

function EnterAnimation:draw()
	if not self.hasPlayedOnEnter then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SKIP_ENTER_ANIMATION"), self.typeDesc), InputBinding.SKIP_ENTER_ANIMATION);
	end;
end;

function EnterAnimation:skipAnimation()
	self.hasEntered = true;
	disableAnimTrack(self.onEnterAnimCharSet, 0);
	setAnimTrackTime(self.onEnterAnimCharSet, 0, 8500.0);
	setTranslation(self.onEnterAnimRootNode, 0, 0, 0);
	setRotation(self.onEnterAnimRootNode, math.rad(0), math.rad(0), math.rad(0));
end;

function EnterAnimation:onLeave()
	self.hasEntered = false;
	self.hasOpenedDoor = false;
	self.hasPlayedOnEnter = true;
	disableAnimTrack(self.onEnterAnimCharSet, 0);
	setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
	setTranslation(self.onEnterAnimRootNode, 1.98976, -1.2, 1.1);
	setRotation(self.onEnterAnimRootNode, math.rad(164), math.rad(-80), math.rad(180));
end;

function EnterAnimation:onEnter()
	self.hasPlayedOnEnter = false;
end;
