--
-- flStick
-- This is the specialization for flStick
--
-- M@D Author  Headshot XXL
-- M@D date 19.08.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

flStick = {};

function flStick.prerequisitesPresent(specializations)
    return true;
end;

function flStick:load(xmlFile)
	self.stick = {};
	self.stick.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.flStick#index"));
	self.stick.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.flStick#minRot"))};
	self.stick.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.flStick#maxRot"))};
	self.stick.Rot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.flStick#Rot"))};
	self.stick.rotTime = getXMLFloat(xmlFile, "vehicle.flStick#rotTime")*1000;
    self.stick.posX = true;
    self.stick.posZ = true;
end;

function flStick:delete()
end;

function flStick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function flStick:keyEvent(unicode, sym, modifier, isDown)
end;

function flStick:update(dt)
	

	
	
	

	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POS) then
		    self.stick.posX = true;
			x,y,z = getRotation(self.stick.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.stick.maxRot, self.stick.minRot, 1, self.stick.rotTime, dt, true);
		    setRotation(self.stick.node, newRot[1],y,z);	
	    end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEG) then
		    self.stick.posX = false;
			x,y,z = getRotation(self.stick.node);	
		    local newRot = Utils.getMovedLimitedValues({x}, self.stick.maxRot, self.stick.minRot, 1, self.stick.rotTime, dt, false );
		    setRotation(self.stick.node, newRot[1],y,z);		
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_NEG) and not InputBinding.isPressed(InputBinding.FRONTLOADER_ARM_POS) then
		    if self.stick.posX then
		    	x,y,z = getRotation(self.stick.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.stick.minRot, self.stick.Rot, 1, self.stick.rotTime/2, dt, true);
		        setRotation(self.stick.node, newRot[1],y,z);
            else
			    x,y,z = getRotation(self.stick.node);	
		        local newRot = Utils.getMovedLimitedValues({x}, self.stick.maxRot, self.stick.Rot, 1, self.stick.rotTime/2, dt, true);
		        setRotation(self.stick.node, newRot[1],y,z);		
		    end;
		end;
		if InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POS) then
		 	self.stick.posZ = true;   
			x,y,z = getRotation(self.stick.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.stick.maxRot, self.stick.minRot, 1, self.stick.rotTime, dt, true );
		    setRotation(self.stick.node, x,y,newRot[1]);	
		elseif InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEG) then
		    self.stick.posZ = false;   
			x,y,z = getRotation(self.stick.node);	
		    local newRot = Utils.getMovedLimitedValues({z}, self.stick.maxRot, self.stick.minRot, 1, self.stick.rotTime, dt, false );
		    setRotation(self.stick.node, x,y,newRot[1]);	
		end;
		if not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_NEG) and not InputBinding.isPressed(InputBinding.FRONTLOADER_TILT_POS) then
		    if self.stick.posZ then
			    x,y,z = getRotation(self.stick.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.stick.minRot, self.stick.Rot, 1, self.stick.rotTime/2, dt, true);
		        setRotation(self.stick.node, x,y,newRot[1]);		
		    else
			    x,y,z = getRotation(self.stick.node);	
		        local newRot = Utils.getMovedLimitedValues({z}, self.stick.maxRot, self.stick.Rot, 1, self.stick.rotTime/2, dt, true);
		        setRotation(self.stick.node, x,y,newRot[1]);		
			end;
		end;		
	end;

	
end;

function flStick:draw()
end;