--
-- radscheibe
-- This is the specialization for radscheibe
--
-- Author  Treckerjack
-- date 12.10.2011
--
-- > Copyright (C) Treckerjack ls-umbau < --

radscheibe = {};

function radscheibe.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function radscheibe:load(xmlFile)

    self.radscheibe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.radscheibe#index"));
	 
end;

function radscheibe:keyEvent(unicode, sym, modifier, isDown)

end;

function radscheibe:update(dt)
  
  if self.isMotorStarted then
      if self.radscheibe ~= nil then
        rotate(self.radscheibe, self.motor.lastMotorRpm*1.5, 0, 0);  
	end;	
  end;

end;

function radscheibe:draw()
end;

function radscheibe:onEnter()
end;

function radscheibe:onLeave()
end;

function radscheibe:delete()
end;

function radscheibe:mouseEvent(posX, posY, isDown, isUp, button)
end;