--
-- Ladekranalpha
--
-- M@D Author    Gorli
-- M@D date  29.04.2009
--
-- > Copyright (C)  Gorli< --


Ladekranalpha = {}

function Ladekranalpha.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Ladekranalpha:load(xmlFile)
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
    
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
    local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;
    
      local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;
 
         local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
        self.rotation5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#touchRotLimit"), 10));
    end;
 
	local rotationNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation6#index"));
    if rotationNode6 ~= nil then
        self.rotation6 = {};
        self.rotation6.node = rotationNode6;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#minRot"));
        self.rotation6.minRot = {};
        self.rotation6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation6#maxRot"));
        self.rotation6.maxRot = {};
        self.rotation6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#rotTime"), 2)*1000;
        self.rotation6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation6#touchRotLimit"), 10));
    end;
end;
      
function Ladekranalpha:delete()
end;

function Ladekranalpha:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Ladekranalpha:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_KP_9 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationMin = isDown;
	end;
	if sym == Input.KEY_KP_5 then
		self.rotation1Max = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.rotation1Min = isDown;
	end;
	if sym == Input.KEY_j then
		self.rotation2Max = isDown;
		self.rotation3Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation2Min = isDown;
		self.rotation3Min = isDown;
	end;
	if sym == Input.KEY_KP_7 then
		self.rotation4Max = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.rotation4Min = isDown;
	end;
	if sym == Input.KEY_u then
		self.rotation5Max = isDown;
	end;
	if sym == Input.KEY_o then
		self.rotation5Min = isDown;
	end;
	if sym == Input.KEY_b then
		self.rotation6Max = isDown;
	end;
	if sym == Input.KEY_n then
		self.rotation6Min = isDown;
	end;

end;

function Ladekranalpha:update(dt)
	
	local doTranslate = self.translationMax or self.translationMin 
	if self.translationPart ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax); 
		setTranslation(self.translationPart.node, unpack(newTrans)); 
	end; 
	
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
    end;
    
    local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
    end;
    
       local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
    end;
	
	   local doRotate = self.rotation5Max or self.rotation5Min 
	if self.rotation5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
    end;
	
	local doRotate = self.rotation6Max or self.rotation6Min 
	if self.rotation6 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation6.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation6.maxRot, self.rotation6.minRot, 3, self.rotation6.rotTime, dt, not self.rotation6Max);
        setRotation(self.rotation6.node, unpack(newRot));
    end;
end;

function Ladekranalpha:draw()
end;

function Ladekranalpha:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
