--
-- EstonianCountrysideV2
--
-- Copyright (C) Ace-uk, Confidential, All Rights Reserved.

EstonianCountrysideV2 = {}

local EstonianCountrysideV2_mt = Class(EstonianCountrysideV2, Mission00);

function EstonianCountrysideV2:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = EstonianCountrysideV2_mt;
    end;
    local self = EstonianCountrysideV2:superClass():new(baseDirectory, mt);
    return self;
end;

function EstonianCountrysideV2:delete()
    EstonianCountrysideV2:superClass().delete(self);
end;

function EstonianCountrysideV2:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));    
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    EstonianCountrysideV2:superClass().load(self);
end
function EstonianCountrysideV2:loadFinished()
    EstonianCountrysideV2:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function EstonianCountrysideV2:mouseEvent(posX, posY, isDown, isUp, button)
    EstonianCountrysideV2:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function EstonianCountrysideV2:keyEvent(unicode, sym, modifier, isDown)
    EstonianCountrysideV2:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function EstonianCountrysideV2:update(dt)
    EstonianCountrysideV2:superClass().update(self, dt);
end;

function EstonianCountrysideV2:draw()
    EstonianCountrysideV2:superClass().draw(self);
end;
