-- Script is Open Source
-- Lights
-- @H-P-J3000 - Part Of DJ Modding
-- @Date 11/03/11 
--

Lights = {};

function Lights.prerequisitesPresent(specializations)
    return true;
end;

function Lights:load(xmlFile)
--Warning Light
	self.WarningLight = {};
	self.SetLightState = SpecializationUtil.callSpecializationsFunction("SetLightState");
	self.WarningLight[1] = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.WarningLight.WarningLights#index1"));
	self.intervall = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.WarningLight#intervall"), 0.5) * 1000;
	self.currentTime = self.intervall;
	self.isLightActive = false;
--Indicators
--Left Light
	self.Left = {};
	self.SetLeftState = SpecializationUtil.callSpecializationsFunction("SetLeftState");
	self.Left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Indicators.Left#index1"));
	self.intervallLeft = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeLeft = self.intervallLeft;
	self.isLeftActive = false;
--Right Light
	self.Right = {};
	self.SetRightState = SpecializationUtil.callSpecializationsFunction("SetRightState");
	self.Right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Indicators.Right#index1"));
	self.intervallRight = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeRight = self.intervallRight;
	self.isRightActive = false;
--Hazzards
	self.SetHazzardsState = SpecializationUtil.callSpecializationsFunction("SetHazzardsState");
	self.intervallHazzards = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Indicators#intervall"), 0.5) * 1000;
	self.currentTimeHazzards = self.intervallHazzards;
	self.isHazzardsActive = false;


end;

function Lights:delete()    
end;

function Lights:readStream(streamId, connection)
      local isLightActive = streamReadBool(streamId);
      local isLeftActive = streamReadBool(streamId);
      local isRightActive = streamReadBool(streamId);
      local isHazzardsActive = streamReadBool(streamId);
      self:SetLightState(isLightActive, true);
      self:SetLeftState(isLeftActive, true);
      self:SetRightState(isRightActive, true);
      self:SetHazzardsState(isHazzardsActive, true);
end;
  
function Lights:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isLightActive);
      streamWriteBool(streamId, self.isLeftActive);
      streamWriteBool(streamId, self.isRightActive);
      streamWriteBool(streamId, self.isHazzardsActive);
end;

function Lights:mouseEvent(posX, posY, isDown, isUp, button)    
end;

function Lights:keyEvent(unicode, sym, modifier, isDown)
end;

function Lights:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_BEACON_LIGHTS) then
			self:SetLightState(not self.isLightActive);
		end;	
		if InputBinding.hasEvent(InputBinding.IndicatorsLeft) and not self.isHazzardsActive then
			self:SetLeftState(not self.isLeftActive);
			self:SetRightState(false);
			self:SetHazzardsState(false);

		end;
		if InputBinding.hasEvent(InputBinding.IndicatorsRight) and not self.isHazzardsActive then
			self:SetRightState(not self.isRightActive);
			self:SetLeftState(false);
			self:SetHazzardsState(false);
		end;	
		if InputBinding.hasEvent(InputBinding.Hazzards) then
			self:SetHazzardsState(not self.isHazzardsActive);
		end;
	end;
end;

function Lights:updateTick(dt) 
--Warning Light
	if self.isLightActive == true then

		if self.currentTime < 0 then
			setVisibility(self.WarningLight[1], not getVisibility(self.WarningLight[1])); 
			self.currentTime = self.intervall;
		end;
		self.currentTime = self.currentTime - dt;
	else
		self.currentTime = self.intervall;
	end;
--Left	
	if self.isLeftActive == true then

		if self.currentTimeLeft < 0 then
			setVisibility(self.Left, not getVisibility(self.Left));
			self.currentTimeLeft = self.intervallLeft;
		end;
		self.currentTimeLeft = self.currentTimeLeft - dt;
	else
		self.currentTimeLeft = self.intervallLeft;
	end;
--Right	
	if self.isRightActive == true then

		if self.currentTimeRight < 0 then
			setVisibility(self.Right, not getVisibility(self.Right));
			self.currentTimeRight = self.intervallRight;
		end;
		self.currentTimeRight = self.currentTimeRight - dt;
	else
		self.currentTimeRight = self.intervallRight;
	end;
--Hazzards	
	if self.isHazzardsActive == true then
		if self.currentTimeHazzards < 0 then
			setVisibility(self.Right, not getVisibility(self.Right));
			setVisibility(self.Left, not getVisibility(self.Left));
			self.currentTimeHazzards = self.intervallHazzards;
		end;
		self.currentTimeHazzards = self.currentTimeHazzards - dt;
	else
		self.currentTimeHazzards = self.intervallHazzards;
	end;
	
	if self.isHazzardsActive then
		self.isRightActive = false;
		self.isLeftActive = false;	
	end;

end;

function Lights:onDetach()
	self:SetLightState(false,true);
	self:SetLeftState(false,true);
	self:SetRightState(false,true);
	self:SetHazzardsState(false,true);
end;

function Lights:draw()
end;

--Wanring light Mp Event
function Lights:SetLightState(isActive,noEventSend)
	if self.isLightActive ~= isActive then
		LightStateEvent.sendEvent(self,isActive,noEventSend);
		self.isLightActive = isActive;		
		setVisibility(self.WarningLight[1],isActive);
	end;
end;
--Left
function Lights:SetLeftState(isLeft,noEventSend)
	if self.isLeftActive ~= isLeft then
		LeftLightStateEvent.sendEvent(self,isLeft,noEventSend);
		self.isLeftActive = isLeft;		
		setVisibility(self.Left,isLeft);
	end;
end;
--Right
function Lights:SetRightState(isRight,noEventSend)
	if self.isRightActive ~= isRight then
		RightLightStateEvent.sendEvent(self,isRight,noEventSend);
		self.isRightActive = isRight;		
		setVisibility(self.Right,isRight);
	end;
end;
--Hazzards
function Lights:SetHazzardsState(isHazzards,noEventSend)
	if self.isHazzardsActive ~= isHazzards then
		HazzardLightStateEvent.sendEvent(self,isHazzards,noEventSend);
		self.isHazzardsActive = isHazzards;		
		setVisibility(self.Right, isHazzards);
		setVisibility(self.Left, isHazzards);
	
	end;
	
	if self.isHazzardsActive then
		self.isRightActive = false;
		self.isLeftActive = false;	
	end;
end;

LightStateEvent = {};
LightStateEvent_mt = Class(LightStateEvent, Event);
  
InitEventClass(LightStateEvent, "LightStateEvent");
  
function LightStateEvent:emptyNew()
      local self = Event:new(LightStateEvent_mt);
      self.className="LightStateEvent";
      return self;
end;
  
function LightStateEvent:new(vehicle, isActive)
      local self = LightStateEvent:emptyNew()
      self.vehicle = vehicle;
	  self.isActive = isActive; 
      return self;
end;
  
function LightStateEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
			self.isActive = streamReadBool(streamId);
			self:run(connection);
end;
  
function LightStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
  	streamWriteBool(streamId, self.isActive);
end;
  
function LightStateEvent:run(connection)
      self.vehicle:SetLightState(self.isActive,true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(LightStateEvent:new(self.vehicle, self.isActive), nil, connection, self.vehicle);
      end;
end;
  
function LightStateEvent.sendEvent(vehicle, isActive, noEventSend)
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(LightStateEvent:new(vehicle, isActive), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(LightStateEvent:new(vehicle, isActive));
              end;
          end;
end;

LeftLightStateEvent = {};
LeftLightStateEvent_mt = Class(LeftLightStateEvent, Event);
  
InitEventClass(LeftLightStateEvent, "LeftLightStateEvent");
  
function LeftLightStateEvent:emptyNew()
      local self = Event:new(LeftLightStateEvent_mt);
      self.className="LeftLightStateEvent";
      return self;
end;
  
function LeftLightStateEvent:new(vehicle, isLeft)
      local self = LeftLightStateEvent:emptyNew()
      self.vehicle = vehicle;
	  self.isLeft = isLeft;
      return self;
end;
  
function LeftLightStateEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
			self.isLeft = streamReadBool(streamId);
			self:run(connection);
end;
  
function LeftLightStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
  	streamWriteBool(streamId, self.isLeft);
end;
  
function LeftLightStateEvent:run(connection)
      self.vehicle:SetLeftState(self.isLeft,true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(LeftLightStateEvent:new(self.vehicle, self.isLeft), nil, connection, self.vehicle);
      end;
end;
  
function LeftLightStateEvent.sendEvent(vehicle, isLeft, noEventSend)
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(LeftLightStateEvent:new(vehicle, isLeft), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(LeftLightStateEvent:new(vehicle, isLeft));
              end;
          end;
end;

RightLightStateEvent = {};
RightLightStateEvent_mt = Class(RightLightStateEvent, Event);
  
InitEventClass(RightLightStateEvent, "RightLightStateEvent");
  
function RightLightStateEvent:emptyNew()
      local self = Event:new(RightLightStateEvent_mt);
      self.className="RightLightStateEvent";
      return self;
end;
  
function RightLightStateEvent:new(vehicle, isRight)
      local self = RightLightStateEvent:emptyNew()
      self.vehicle = vehicle;
	  self.isRight = isRight;
      return self;
end;
  
function RightLightStateEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
			self.isRight = streamReadBool(streamId);
			self:run(connection);
end;
  
function RightLightStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
  	streamWriteBool(streamId, self.isRight);
end;
  
function RightLightStateEvent:run(connection)
      self.vehicle:SetRightState(self.isRight,true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(RightLightStateEvent:new(self.vehicle, self.isRight), nil, connection, self.vehicle);
      end;
end;
  
function RightLightStateEvent.sendEvent(vehicle, isRight, noEventSend)
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(RightLightStateEvent:new(vehicle, isRight), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(RightLightStateEvent:new(vehicle, isRight));
              end;
          end;
end;


HazzardLightStateEvent = {};
HazzardLightStateEvent_mt = Class(HazzardLightStateEvent, Event);
  
InitEventClass(HazzardLightStateEvent, "HazzardLightStateEvent");
  
function HazzardLightStateEvent:emptyNew()
      local self = Event:new(HazzardLightStateEvent_mt);
      self.className="HazzardLightStateEvent";
      return self;
end;
  
function HazzardLightStateEvent:new(vehicle, isHazzards)
      local self = HazzardLightStateEvent:emptyNew()
      self.vehicle = vehicle;
	  self.isHazzards = isHazzards;
      return self;
end;
  
function HazzardLightStateEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
			self.isHazzards = streamReadBool(streamId);
			self:run(connection);
end;
  
function HazzardLightStateEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
  	streamWriteBool(streamId, self.isHazzards);
end;
  
function HazzardLightStateEvent:run(connection)
      self.vehicle:SetHazzardsState(self.isHazzards,true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(HazzardLightStateEvent:new(self.vehicle, self.isHazzards), nil, connection, self.vehicle);
      end;
end;
  
function HazzardLightStateEvent.sendEvent(vehicle, isHazzards, noEventSend)
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(HazzardLightStateEvent:new(vehicle, isHazzards), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(HazzardLightStateEvent:new(vehicle, isHazzards));
              end;
          end;
end;