

BrakeLight = {};

function BrakeLight.prerequisitesPresent(specializations)
    return true;
end;

function BrakeLight:load(xmlFile)

 
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

	self.brakelightsActive = false;
    self.braking = false;
    
end;

function BrakeLight:keyEvent(unicode, sym, modifier, isDown)
 
end;

function BrakeLight:update(dt)
 
	

	
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;

		
		if self.attacherVehicle ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
	
	
end;


function BrakeLight:draw()

  
end;

function BrakeLight:onEnter()
  
end;

function BrakeLight:onLeave()
 
end;

function BrakeLight:delete()

end;


function BrakeLight:mouseEvent(posX, posY, isDown, isUp, button)
end;