---xyzspain
Elho_Twin_600= {};


function Elho_Twin_600.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(Attachable, specializations);
	
end;

function Elho_Twin_600:load(xmlFile)
	self.setStateEvent= SpecializationUtil.callSpecializationsFunction("setStateEvent");
	
	
	  
	  
	  
	   self.animation = {};
    self.animation.animCharSet = 0;
    self.animationEnabled = false;
	self.animationSpeed = 0;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
    if rootNode ~= nil then
        self.animation.animCharSet = getAnimCharacterSet(rootNode);
        if self.animation.animCharSet ~= 0 then
            self.animation.clip = getAnimClipIndex(self.animation.animCharSet, getXMLString(xmlFile, "vehicle.animation#animationClip"));
            if self.animation.clip >= 0 then
                assignAnimTrackClip(self.animation.animCharSet, 0, self.animation.clip);
                self.animation.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
                setAnimTrackSpeedScale(self.animation.animCharSet, self.animation.clip, self.animation.speedScale);
                setAnimTrackLoopState(self.animation.animCharSet, 0, true);
            end;
        end;
		
    end;

	
	
	 self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
		-- desplazamiento de conjuntos
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
		self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		self.hydraulics[i].doScale = Utils.getNoNil(getXMLBool(xmlFile, hydraulicName .. "#doScale"), false);
	end;
	-------------------
	
			---libertad bloques
	self.setJointRotLimit = SpecializationUtil.callSpecializationsFunction("setJointRotLimit");
	self.firstDo = {};
	self.arm = {};
	
	
	
	
	
	
	
	--rotaciones y translaciones
	------------------------------
		--- ajuste orientacion attach
		
	local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
	end;
 
		--------------------------
	
	---lift 
	    local numRotParts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.RotParts#count"), 0);
    self.RotParts = {};
    for i=1, numRotParts do
      local partnamei = string.format("vehicle.RotParts.part" .. "%d", i);
      self.RotParts[i] = {};
      self.RotParts[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
      local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#minRot"));
      self.RotParts[i].minRot = {};
      self.RotParts[i].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partnamei .. "#maxRot"));
      self.RotParts[i].maxRot = {};
      self.RotParts[i].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
      self.RotParts[i].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
      self.RotParts[i].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
      self.RotParts[i].rotTime = Utils.getNoNil(getXMLString(xmlFile,  partnamei .. "#rotSpeed"), 2)*1000;
    end;
	
	
	local translationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.translation1#index"));
    if translationNode1 ~= nil then
        self.translation1 = {};
        self.translation1.node = translationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#minTrans"));
        self.translation1.minTrans = {};
        self.translation1.minTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.minTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translation1#maxTrans"));
        self.translation1.maxTrans = {};
        self.translation1.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translation1.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translation1.maxTrans[3] = Utils.getNoNil(z, 0);

	    self.translation1.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translation1#transTime"), 2)*1000;
      
    end;
	
	local rotationNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
     
    end;
	
	------------------------------
	
	
	self.vehicleType = getXMLString(xmlFile, "vehicle#type");

----------------
	
-----------------
 local workSound = getXMLString(xmlFile, "vehicle.start#file");
    if workSound ~= nil and workSound ~= "" then
       workSound = Utils.getFilename(workSound, self.baseDirectory);
       self.workSound = createSample("start");
       self.workSoundEnabled = false;
       loadSample(self.workSound, workSound, false);
       self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.start#pitchOffset"), 1);
       self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.start#volume"), 1);
    end;
	
	local loopSound = getXMLString(xmlFile, "vehicle.loopSound#file");
    if loopSound ~= nil and loopSound ~= "" then
       loopSound = Utils.getFilename(loopSound, self.baseDirectory);
       self.loopSound = createSample("loopSound");
       self.loopSoundEnabled = false;
       loadSample(self.loopSound, loopSound, false);
       self.loopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loopSound#pitchOffset"), 1);
       self.loopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.loopSound#volume"), 1);
    end;
	
	local StopSound = getXMLString(xmlFile, "vehicle.StopSound#file");
    if StopSound ~= nil and StopSound ~= "" then
       StopSound = Utils.getFilename(StopSound, self.baseDirectory);
       self.StopSound = createSample("StopSound");
       self.StopSoundEnabled = true;
       loadSample(self.StopSound, StopSound, false);
       self.StopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.StopSound#pitchOffset"), 1);
       self.StopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.StopSound#volume"), 1);
    end;
	-------------------------
	
					---emision de particulas ruedas

self.wheelParticleSystems = {};
    local psFile = getXMLString(xmlFile, "vehicle.wheelParticleSystems#file");
    if psFile ~= nil then
        local i=0;
        while true do
            local baseName = string.format("vehicle.wheelParticleSystems.wheelParticleSystem(%d)", i);
            local node = getXMLString(xmlFile, baseName.. "#node");
            if node == nil then
                break;
            end;
            node = Utils.indexToObject(self.components, node);
			self.wheelParticleSystems.node = node;
            if node ~= nil then
                local wheelParticleSystem = {};
                wheelParticleSystem.particleSystems = {};
                Utils.loadParticleSystem(xmlFile, wheelParticleSystem.particleSystems, "vehicle.wheelParticleSystems", node, false, nil, self.baseDirectory);
                table.insert(self.wheelParticleSystems, wheelParticleSystem);
            end;
            i = i+1;
        end;
    end;
	-----------------------
---------------ground cutting areas
local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
	
		self.cuttingAreas[i].groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#groundReferenceNode"));
    end;
	
    local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
 self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
----------------
	self.wheatParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.wheatParticleSystems.wheatParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.wheatParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
		self.wheatParticleSystemsdisableTime=0;		
		i = i +1;		
    end;
	
	self.barleyParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.barleyParticleSystems.barleyParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.barleyParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
			self.barleysParticleSystemsdisableTime =0;
		i = i +1;		
    end;
	
	self.grassParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.grassParticleSystems.grassParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.grassParticleSystems, namei, nodei, false, nil, self.baseDirectory)		
		self.grassParticleSystemsdisableTime=0;
		i = i +1;		
    end;
	
	self.drygrassParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.drygrassParticleSystems.drygrassParticleSystems(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.drygrassParticleSystems, namei, nodei, false, nil, self.baseDirectory)	
		self.drygrassParticleSystemsdisableTime=0;
		i = i +1;		
    end;
	
	
	
	self.soundOffset = 0;
	self.time=0;
	 self.isTurnedOn = false;
	self.front=true;
	
	 self.rotParts =false;

	self.translation1max= false;
	
	self.rotation1max=false; 
	 -- self.front=false;
	-- self.translation1max= true;
	 -- self.rotation1max=true; 
			---------------------------
		
	
end;	
function Elho_Twin_600:delete()
  if self.StopSound ~= nil then
        delete(self.StopSound);
    end;	    
	if self.loopSound ~= nil then
        delete(self.loopSound);
    end;	    
	if self.workSound ~= nil then
        delete(self.workSound);
    end;	
	
end;
function Elho_Twin_600:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Elho_Twin_600:keyEvent(unicode, sym, modifier, isDown)
	self.on=true;

	
	
	

	
end;

function Elho_Twin_600:update(dt)
	
	
if self.attacherVehicle then
---particulas ruedas

	local dens = 0; local dens1; local dens2; local dens3;
		 local x,y,z = getWorldTranslation(self.wheels[1].repr);
		 local x1,y1,z1 = getWorldTranslation(self.wheels[2].repr);
		 local x2,y2,z2 = getWorldTranslation(self.wheels[3].repr);
		local id = g_currentMission.terrainDetailId;
		local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
		dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
		dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
		dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
		if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
			dens = dens1+dens2+dens3;
		end;
		if dens > 0 and self.lastSpeed*self.speedDisplayScale*3600 > 4 then
			
			
			for k=1, 4 do
				Utils.setEmittingState(self.wheelParticleSystems[k].particleSystems, self.wheels[k].hasGroundContact);
			end;
		else
			for i=1, table.getn(self.wheelParticleSystems) do
				Utils.setEmittingState(self.wheelParticleSystems[i].particleSystems, false);
			end;
		
		end;
	
		
	if self:getIsActiveForInput() then
	 

---------------	
	
	
		   if InputBinding.hasEvent (InputBinding.SWITCH_IMPLEMENT) then 
		   self:setStateEvent("on", not self.on)
			
			end;
	if self.on then
		
		---- ajuste attach
		
		
			if InputBinding.isPressed (InputBinding.TURN_UP) then
			self:setStateEvent("down", not self.down)
			
			
			end;
			if InputBinding.isPressed (InputBinding.TURN_DOWN) then
			self:setStateEvent("up", not self.up)
			
			
			end;
		-----------------------change attach---------------------
		 if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
              self:setStateEvent("front",not self.front);
           end;
		
						------------------------- lower raise-------------
			
		
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
							self:setStateEvent("rotParts", not self.rotParts)
							
					end;
	
			--------------------------------------
			
	  if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
              self:setStateEvent("isTurnedOn",not self.isTurnedOn);
           end;
	end;		----on	
end;
			if self.time > self.drygrassParticleSystemsdisableTime then
           Utils.setEmittingState(self.drygrassParticleSystems, false);
		end;
		if self.time > self.grassParticleSystemsdisableTime then
           Utils.setEmittingState(self.grassParticleSystems, false);
		end;
		if self.time > self.wheatParticleSystemsdisableTime then
           Utils.setEmittingState(self.wheatParticleSystems, false);
		end;
		if self.time > self.barleysParticleSystemsdisableTime then
           Utils.setEmittingState(self.barleysParticleSystems, false);
		end;						
	
			
	
		   if self.isTurnedOn then
			     self.StopSoundEnabled = false;	
			if not self.workSoundEnabled then
			    playSample(self.workSound, 1, self.workSoundVolume, 0);
				setSamplePitch(self.workSound, self.workSoundPitchOffset);
				self.workSoundEnabled = true;
				local SoundOffset = getSampleDuration(self.workSound); 
				self.playSoundTime = self.time+SoundOffset;			
			end;			
			if self.playSoundTime <= self.time and not self.loopSoundEnabled then
				playSample(self.loopSound, 0, self.loopSoundVolume, 0);
				setSamplePitch(self.loopSound, self.loopSoundPitchOffset);
				self.loopSoundEnabled = true;
				self.runMower = true; 
				stopSample(self.workSound);		
			end;					
		  
			    if not self.animationEnabled then
                enableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = true;
			else
				if self.animationSpeed < (self.animation.speedScale - 0.01) then
					local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, false);
					self.animationSpeed = newSpeed[1];
					setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
				end;
            end;
		  else
				if self.animationEnabled and self.animationSpeed < 0.01 then
                disableAnimTrack(self.animation.animCharSet, 0);
                self.animationEnabled = false;
				else
				local newSpeed = Utils.getMovedLimitedValues({self.animationSpeed}, {self.animation.speedScale}, {0}, 1, self.animation.offsetTime, dt, true);
				self.animationSpeed = newSpeed[1];
				setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animationSpeed);
            end;
			 self.workSoundEnabled = false;
			
			if self.loopSoundEnabled then
				stopSample(self.loopSound);
				self.loopSoundEnabled = false;
			end;
			if not self.StopSoundEnabled then
			    playSample(self.StopSound, 1, self.StopSoundVolume, 0);
				setSamplePitch(self.StopSound, self.StopSoundPitchOffset);
				self.StopSoundEnabled = true;
			end; 
		   end;---turnedon
		   -----------------------------------------areas------------------------------------
	if self.isTurnedOn and not self.rotParts then	
		
							
					
			
				local numDropAreas = table.getn(self.windrowerDropAreas);
				local numAreas = table.getn(self.cuttingAreas);
				local sum = 0;
				local fruitType = FruitUtil.FRUITTYPE_GRASS;					
				local fruitTypeFix = false;
				for i=1, 3 do 					
					if i==2 then
						fruitType = FruitUtil.FRUITTYPE_WHEAT;
							
							
					elseif i==3 then
						fruitType = FruitUtil.FRUITTYPE_BARLEY;
					
					end;						
					for j=1, numAreas  do
						local cuttingArea = self.cuttingAreas[j];
						
							local x,y,z = getWorldTranslation(cuttingArea.groundReferenceNode);
							local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);	
							
							if terrainHeight+self.groundReferenceThreshold >= y then
							
								
								local x,y,z = getWorldTranslation(cuttingArea.start);
								local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
								local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

								local ratio = g_currentMission.windrowCutLongRatio;

									if not fruitTypeFix and i==1 then
										fruitType = FruitUtil.FRUITTYPE_GRASS;
										
									end;

								local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
								area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
								
								if area == 0 and not fruitTypeFix and i==1 then
									fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
								
									area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
									area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
								end;

								if area > 0 then
									fruitTypeFix = true;
										
								end;

								if numDropAreas >= numAreas then
									if area > 0 then
										local dropArea = self.windrowerDropAreas[j];
										---renderText(0,0.45,0.05,"fruitType: " .. fruitType);	
										local x,y,z = getWorldTranslation(dropArea.start);
										local x1,y1,z1 = getWorldTranslation(dropArea.width);
										local x2,y2,z2 = getWorldTranslation(dropArea.height);
										local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
										area = area + old;
										local value = area / total;
										if value < 1 and value > 0.08 then
											value = 1;
										else
											value = math.floor(value + 0.7); -- round, biased to the bigger value
										end;
										if value >= 1 then
											value = math.min(value, g_currentMission.maxWindrowValue);
											Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
										
										--------------------emision particulas--------------
											---renderText(0.1, 0.15, 0.03," particle ");
												if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 30 then
										
													if fruitType== FruitUtil.FRUITTYPE_DRYGRASS then
													---renderText(0.1, 0.22, 0.03,"fruitType: " .. fruitType);
													self.drygrassParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.drygrassParticleSystems, true)
													elseif fruitType== FruitUtil.FRUITTYPE_GRASS then
													---renderText(0.1, 0.18, 0.03,"fruitType: " .. fruitType);----5---
														self.grassParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.grassParticleSystems, true)
													elseif fruitType== FruitUtil.FRUITTYPE_WHEAT then------2-----
													---renderText(0.1, 0.25, 0.03,"fruitType: " .. fruitType);
														self.wheatParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.wheatParticleSystems, true)
													elseif fruitType==FruitUtil.FRUITTYPE_BARLEY then
													---renderText(0.1, 0.28, 0.03,"fruitType: " .. fruitType);
														self.barleysParticleSystemsdisableTime = self.time + 20;
														Utils.setEmittingState(self.barleysParticleSystems, true)
													end; 
												end;		
										end;									
												
										
									end;
								 else
									 sum = sum + area;
								 end;
							else
						-----------particulas--------------
							Utils.setEmittingState(self.drygrassParticleSystems, false)
							Utils.setEmittingState(self.grassParticleSystems, false)
							Utils.setEmittingState(self.wheatParticleSystems, false)
							Utils.setEmittingState(self.barleysParticleSystems, false)
							end;
						---------
					end;
					if sum > 0 and numDropAreas > 0 then
						local dropArea = self.windrowerDropAreas[2];
						local x,y,z = getWorldTranslation(dropArea.start);
						local x1,y1,z1 = getWorldTranslation(dropArea.width);
						local x2,y2,z2 = getWorldTranslation(dropArea.height);
						local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
						sum = sum + old;
						local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
						if value >= 1 then
							value = math.min(value, g_currentMission.maxWindrowValue);
							Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true);
							----renderText(0.5, 0.1, 0.03,"fruitType: " .. fruitType);
						end;					
					end;
					
				end;
		
		end; ---turnedOn
		
------------------------------------areas--------------------------------------------
end;
	----rotaciones y translaciones

		if self.rotation1max ~= nil then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1max);
        setRotation(self.rotation1.node, unpack(newRot));
    end;
	
	
		if self.rotParts ~= nil   then
				for i=1, table.getn(self.RotParts) do
					local rot = {getRotation(self.RotParts[i].index)};
					local newRot = Utils.getMovedLimitedValues(rot, self.RotParts[i].maxRot, self.RotParts[i].minRot, 3, self.RotParts[i].rotTime, dt, not self.rotParts);
					setRotation(self.RotParts[i].index, unpack(newRot));
				end;
		end;
		 if self.down then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
			setRotation(rotationPart.index, unpack(newRot));
	    end;		
		if self.up then
			local rotationPart = self.rotationParts.rotationPart1;
			local rot = {getRotation(rotationPart.index)};
			local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
			setRotation(rotationPart.index, unpack(newRot));
	    end;  	

	
	if self.translation1 ~= nil  then 
		local x, y, z = getTranslation(self.translation1.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translation1.maxTrans, self.translation1.minTrans, 3, self.translation1.transTime, dt, not self.translation1max); 
		setTranslation(self.translation1.node, unpack(newTrans)); 
	end;
	
		--- asignacion de ejes de libertad  de rotacion segun condiciones de emsamblage  0 x, 2 z ,1 y  
		
		
	 self:setJointRotLimit(self.componentJoints[3],15, 0, 1000,self.rotParts == false , 2,dt);	
	 self:setJointRotLimit(self.componentJoints[6],15, 0, 1000,self.rotParts == false , 2,dt);	
	
	 
	-- juntas

	
			for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
		end;
		
		
		self:setHydraulicDirection();

end;



function Elho_Twin_600:draw()  
  if self.attacherVehicle  then
		g_currentMission:addExtraPrintText(g_i18n:getText(self.vehicleType..".1"));

  if self.front then
		 g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Change_Front"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	else
	 g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Change_Rear"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
	end;
end;
		if self.isTurnedOn then
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
           else
               g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
           end;
		
end;

function Elho_Twin_600:onAttach(attacherVehicle)
 self.rotParts =false;
if self.front then
	self.rotation1max=false;
	self.translation1max=false;

elseif not self.front then
	self.rotation1max=true;
	self.translation1max=true;
end;


 
	self.on=false;
end;
function Elho_Twin_600:onDetach()
 self.rotParts =false;
if self.front then
	self.rotation1max=false;
	self.translation1max=false;

elseif not self.front then
	self.rotation1max=true;
	self.translation1max=true;
end;
	self.on=false;
    if self.deactivateOnDetach then
        Elho_Twin_600.onDeactivate(self);
    else
        Elho_Twin_600.onDeactivateSounds(self)
    end;

	
end;

function Elho_Twin_600:onLeave()

    if self.deactivateOnLeave then
        Elho_Twin_600.onDeactivate(self);
    else
        Elho_Twin_600.onDeactivateSounds(self)
    end;

end;

function Elho_Twin_600:onDeactivate()
 if self.animationEnabled then
           disableAnimTrack(self.animation.animCharSet, 0);
           self.animationEnabled = false;
       end;
    Elho_Twin_600.onDeactivateSounds(self)
 	Utils.setEmittingState(self.drygrassParticleSystems, false)
				Utils.setEmittingState(self.grassParticleSystems, false)
				Utils.setEmittingState(self.wheatParticleSystems, false)
				Utils.setEmittingState(self.barleysParticleSystems, false)
		
				
    self.isTurnedOn = false;

end;

function Elho_Twin_600:onDeactivateSounds()
			if self.loopSoundEnabled then
		stopSample(self.loopSound);
		self.loopSoundEnabled = false;
	end;

		

end;


function Elho_Twin_600:setJointRotLimit(nodei, up, down, speed, value, axle, dt)

	if not self.firstDo[nodei] then
		self.firstDo[nodei] = true;
		self.arm[nodei] = {0}; 
	end; 
	x, y, z = getRotation(nodei);
	rot = {x,y,z};	
	newRotLimit = {}; 
	newRotLimit[nodei] = {0,0,0};
	newRotLimit[nodei] = Utils.getMovedLimitedValues(self.arm[nodei], {down}, {up}, 1, speed * 2, dt, value);
	if math.abs(newRotLimit[nodei][1] - self.arm[nodei][1]) > 0.001 then
		local joint = nodei;
		setJointRotationLimit(joint.jointIndex, axle, true, Utils.degToRad(-newRotLimit[nodei][1]), Utils.degToRad(newRotLimit[nodei][1]));
	end;
	self.arm[nodei] = newRotLimit[nodei];			
end;
function Elho_Twin_600:setHydraulicDirection()
	for i=1, table.getn(self.hydraulics) do
		local ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		local bx, by, bz = getWorldTranslation(self.hydraulics[i].fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulics[i].node), bx-ax, by-ay, bz-az);
		
		setDirection(self.hydraulics[i].node, x, y, z, 0, 1, 0);
		local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		if self.hydraulics[i].doScale then
			local xScale, yScale, zScale = getScale(self.hydraulics[i].node);
			local newScale = yScale * (distance / self.hydraulics[i].punchDistance);
			setScale(self.hydraulics[i].node, 1, 1, newScale);
		else
			if self.hydraulics[i].punch ~= nil then
				setTranslation(self.hydraulics[i].punch, 0, 0, distance-self.hydraulics[i].punchDistance);
			end;
		end;
	
	end;
end; 

 -- function Elho_Twin_600:getSaveAttributesAndNodes(nodeIdent)
-- if self.front then
					
	-- front = "true";	
-- else		
	-- front = "false";	
-- end;		
	


	 -- local attributes = 'front="'..tostring(front)..'"';	-- 'name="'..tostring(name)..'" name="'..tonumber(name)..'"';
	
	-- return attributes, nil;
 -- end;


-- function Elho_Twin_600:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    -- local front = getXMLString(xmlFile, key.."#front");
	
	-- if front == "true" not resetVehicles then
	
	-- self.resetVehicles=true;
	-- self.rotation1max=false;
	-- self.translation1max= false;
	
	-- end; 
	
    -- return BaseMission.VEHICLE_LOAD_OK;
-- end;



function Elho_Twin_600:setStateEvent(level1, value, noEventSend)
	
    if value== true then
      value = "true"
    elseif value==false then
      value = "false"
    elseif value ~= "true" and value ~= "false" then
      value = string.format("%f", value)
    end
	
	Elho_Twin_600Event.sendEvent(self, level1, value, noEventSend);
    	
	if value== "true" then
      value = true
    elseif value=="false" then
      value = false
    elseif value ~= true and value ~= false then
      value = value * 1.0
    end
	
    self[level1]= value;
end;

function Elho_Twin_600:readStream(streamId, connection)  
	

	self.rotParts = streamReadBool(streamId)
	self.on = streamReadBool(streamId)
	self.down = streamReadBool(streamId)
	self.up = streamReadBool(streamId)
	self.isTurnedOn = streamReadBool(streamId)
	 self.front = streamReadBool(streamId)
end

function Elho_Twin_600:writeStream(streamId, connection)
	
	streamWriteBool(streamId, self.rotParts)
	streamWriteBool(streamId, self.on)
	streamWriteBool(streamId, self.down)
	streamWriteBool(streamId, self.up)
	streamWriteBool(streamId, self.isTurnedOn)
	 streamWriteBool(streamId, self.front)
end;


Elho_Twin_600Event = {};
Elho_Twin_600Event_mt = Class(Elho_Twin_600Event, Event);

InitEventClass(Elho_Twin_600Event, "Elho_Twin_600Event");

function Elho_Twin_600Event:emptyNew()  
    local self = Event:new(Elho_Twin_600Event_mt );
    self.className="Elho_Twin_600Event";
    return self;
end;

function Elho_Twin_600Event:new(object, level1, value) 
    self.object = object;
    self.level1 = level1;
    self.value = value;

    return self;
end;

function Elho_Twin_600Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.level1 = streamReadString(streamId);
    self.value = streamReadString(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function Elho_Twin_600Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteString(streamId, self.level1 );
    streamWriteString(streamId, self.value );
end;

function Elho_Twin_600Event:run(connection)
    self.object:setStateEvent(self.level1, self.value, true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(Elho_Twin_600Event:new(self.object, self.level1, self.value), nil, connection, self.object);
    end;
end;

function Elho_Twin_600Event.sendEvent(object, level1, value, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(Elho_Twin_600Event:new(object, level1, value), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(Elho_Twin_600Event:new(object, level1, value));
		end;
	end;
end;


