--
-- Washable
-- Specialization for Washable functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - Changed xml-reading, added updateInterval to define updating interval for vehicles with many ageComponents (performance issue)
--				v3.0 - added network support, changed update to updateTick
--

Age = {};

function Age.prerequisitesPresent(specializations)
    return true;
end;

function Age:load(xmlFile)

	self.increaseAge = SpecializationUtil.callSpecializationsFunction("increaseAge");

	self.unusualAgeIncrease = SpecializationUtil.callSpecializationsFunction("unusualAgeIncrease");
	
	local i = 0;
	self.ageComponents = {};
	while true do
		local path = string.format("vehicle.age.ageComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.ageComponents, component);
		i = i + 1;
	end;	
	
	self.updateInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.age#updateInterval"), 0.05);
	self.ageInterval = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.age#ageInterval"), 1) * 60 * 60 * 1000;


	self.ageScale = 0;
	self.oldAgeScale = self.ageScale;
	self.timeScale = 1;

end;

function Age:readStream(streamId, connection)
    local ageScale = streamReadFloat32(streamId);
    self:unusualAgeIncrease(ageScale);
end;

function Age:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.ageScale);
end;

function Age:delete()
end;

function Age:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Age:keyEvent(unicode, sym, modifier, isDown)
end;

function Age:update(dt)
end;

function Age:updateTick(dt)
	
		if self:getIsActive() or self.isActive then
			self:increaseAge(dt);
		end;

	
	if math.abs(self.ageScale-self.oldAgeScale) > self.updateInterval then
		for i=1, table.getn(self.ageComponents) do
			setShaderParameter(self.ageComponents[i], "ageScale", self.ageScale, 0,0,0,false);
		end;
		self.oldAgeScale = self.ageScale;
	end;
end;

function Age:draw()
end;


function Age:unusualAgeIncrease(increase)
	if self.ageScale < 1 then
		self.ageScale = self.ageScale + increase;
		if self.ageScale > 1 then
			self.ageScale = 1;
		end;
	end;
end;

function Age:increaseAge(dt)
	if self.ageScale > 1 then
		self.ageScale = 1;
	end;
	if self.ageScale < 1 then
		local scale = Utils.getMovedLimitedValues({self.ageScale}, {1}, {0}, 1, self.ageInterval*self.timeScale, dt, false);
		self.ageScale = scale[1];
	end;
end;



function Age:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.ageScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#ageLevel"),0);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Age:getSaveAttributesAndNodes(nodeIdent)	
    local attributes = 'ageLevel="'.. tostring(self.ageScale) .. '"';
    return attributes, nil;
end;