-- by modelleicher
-- http://schwabenmodding.bplaced.net
-- sorgt fr realistische "animation" des Lenkgestaenges bei alten Traktoren
-- V1.2 des EA 400
-- .. Bugfix: Gestnge fr Modelle mit mehreren Components nun mglich
-- .. Bugfix: lenkhebel index1 und index2 nichtmehr zwingend erforderlich (Fr Modelle deren Anlenkung technisch fest am Fender ist)

Lenkgestaenge = {};

function Lenkgestaenge.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Lenkgestaenge:load(xmlFile)
   self.spurstange = {};
   self.lenkstange = {};
   self.lenkhebel = {};
   
   self.lenkhebel.index1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkhebel#index1"));
   self.lenkhebel.index2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkhebel#index2"));
   self.lenkhebel.getRotRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkhebel#getRotRefIndex"));
   self.lenkhebel.lm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Lenkgestaenge.Lenkhebel#lengthMultiplicator"));
   
   self.lenkstange.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkstange#index"));
   self.lenkstange.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkstange#refIndex"));
   self.lenkstange.distanceRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Lenkstange#distanceRef"));
   
   self.spurstange.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Spurstange#index"));
   self.spurstange.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Spurstange#refIndex"));
   self.spurstange.distanceRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Lenkgestaenge.Spurstange#distanceRef"));
end;

function Lenkgestaenge:delete()
end;
function Lenkgestaenge:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Lenkgestaenge:keyEvent(unicode, sym, modifier, isDown)
end;
function Lenkgestaenge:update(dt)
	if self:getIsActive() then
			-- gibt die Rotation des Lenkhebels und des Hebels auf der Achse an --
		local grx, gry, grz = getRotation(self.lenkhebel.getRotRef);
		local rotWert1 = gry * self.lenkhebel.lm
		local rotWert2 = gry
		if self.lenkhebel.index1 ~= nil then 
		setRotation(self.lenkhebel.index1, rotWert1, 0, 0);
		end;
		if self.lenkhebel.index2 ~= nil then
		setRotation(self.lenkhebel.index2, 0, rotWert2, 0);
		end;
			-- legt die Ausrichtung der Lenkstange auf einen Punkt des Hebels fest --
		local px, py, pz = getWorldTranslation(self.lenkstange.ref); 
		local bx, by, bz = getWorldTranslation(self.lenkstange.index);
		local dx = px - bx;
		local dy = py - by;
		local dz = pz - bz;
		local ux, uy, uz = localDirectionToWorld(self.lenkstange.ref, 0, 1, 0);
		dx, dy, dz = worldDirectionToLocal(getParent(self.lenkstange.index), dx, dy, dz);
		ux, uy, uz = worldDirectionToLocal(getParent(self.lenkstange.index), ux, uy, uz);
		setDirection(self.lenkstange.index, dx, dy, dz, ux, uy, uz);	
			-- scaliert die Lenkstange minimal, dass die Gelenke immer exakt aufeinander liegen, anders in LS nicht zu lsen--
		local distanceXc, distanceYc, distanceZc = getWorldTranslation(self.lenkstange.index);
		local distanceXd, distanceYd, distanceZd = getWorldTranslation(self.lenkstange.distanceRef);
		self.lenkstange.distance = Utils.vector3Length(distanceXc-distanceXd, distanceYc-distanceYd, distanceZc-distanceZd);
		local distance2 = Utils.vector3Length(bx-px, by-py, bz-pz);
		local scaleX2, scaleY2, scaleZ2 = getScale(self.lenkstange.index);
		local finalScale2 = scaleZ2 * (distance2 / self.lenkstange.distance)
		setScale(self.lenkstange.index, 1, 1, finalScale2);
			--  legt die Ausrichtung der Spurstange auf einen Punkt am gegenberliegenden Fender fest --
		local px2, py2, pz2 = getWorldTranslation(self.spurstange.ref); 
		local bx2, by2, bz2 = getWorldTranslation(self.spurstange.index);
		local dx2 = px2 - bx2;
		local dy2 = py2 - by2;
		local dz2 = pz2 - bz2;
		local ux2, uy2, uz2 = localDirectionToWorld(self.spurstange.ref, 0, 1, 0);
		dx2, dy2, dz2 = worldDirectionToLocal(getParent(self.spurstange.index), dx2, dy2, dz2);
		ux2, uy2, uz2 = worldDirectionToLocal(getParent(self.spurstange.index), ux2, uy2, uz2);
		setDirection(self.spurstange.index, dx2, dy2, dz2, ux2, uy2, uz2);	
			-- scaliert die Spurstange auf die passende Lnge da in LS die Lenkwinkel nicht Realistisch stimmen, somit etwas "pfuschen" auch hier fr besseres Aussehen--
		local distanceXa, distanceYa, distanceZa = getWorldTranslation(self.spurstange.index)
		local distanceXb, distanceYb, distanceZb = getWorldTranslation(self.spurstange.distanceRef)
		self.spurstange.distance = Utils.vector3Length(distanceXa-distanceXb, distanceYa-distanceYb, distanceZa-distanceZb);
		local distance = Utils.vector3Length(bx2-px2, by2-py2, bz2-pz2);
		local scaleX, scaleY, scaleZ = getScale(self.spurstange.index);
		local finalScale = scaleZ * (distance / self.spurstange.distance)
		setScale(self.spurstange.index, 1, 1, finalScale);
	end;
end;

function Lenkgestaenge:updateTick(dt)
end;
function Lenkgestaenge:draw()
end;

