--
-- Odometer
-- Specialization for counting the distance driven in a vehicle
--
-- Note:  Because I do not know what scale the game is using,  I've "guesstimated" distance calculations in miles.
--		  It still feels a little short for a mile,	 but i figure it's close enough for now.
--		  Modify the Divisor variable if you figure out what the actual ratio of game units to tenths of a mile is
--
-- @author:	 	Robert Hostens
-- @date:		2011/04/10
-- @version:	v1.0
-- @history:	v1.0 - Initial Release
--

Odometer = {};

function Odometer.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Odometer:load(xmlFile)
	self.Odometer = {};

	self.Odometer.Trip = 0;
	self.Odometer.Reading = 0;

	self.Odometer.posX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posX"), 0.7543);
	self.Odometer.posY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.odometer#posY"), 0.2140);
	self.Odometer.HUD = Overlay:new("OdometerOverlay", Utils.getFilename("textury/odometer_hud.png", self.baseDirectory), self.Odometer.posX, self.Odometer.posY, 0.2371, 0.039525);

	self.Odometer.Divisor = 20; -- Game units to tenths of a mile ratio, currently set to best guess
end;

function Odometer:delete()
end;




function Odometer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Odometer:keyEvent(unicode, sym, modifier, isDown)
end;

function Odometer:update(dt)
end;

function Odometer:updateTick(dt)
	if self:getIsActive() or self.isHired then
		self.Odometer.Trip = self.Odometer.Trip + self.lastMovedDistance;
		self.Odometer.Reading = self.Odometer.Reading + self.lastMovedDistance;
	end;
end;

function Odometer:draw()
	local Trip = math.floor(self.Odometer.Trip / self.Odometer.Divisor);
	local Distance = math.floor(self.Odometer.Reading / self.Odometer.Divisor);

	self.Odometer.HUD:render();

	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);
	setTextColor(1,1,1,1);

	renderText(self.Odometer.posX + 0.0770, self.Odometer.posY + 0.009800, 0.02, tostring(Trip));
	renderText(self.Odometer.posX + 0.2170, self.Odometer.posY + 0.009800, 0.02, tostring(Distance));

	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextBold(false);
end;


