--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

D4KShowHelp = {};

function D4KShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function D4KShowHelp:load(xmlFile)
	self.D4KShowHelp = false;
end;

function D4KShowHelp:delete()
end;

function D4KShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function D4KShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function D4KShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.D4KShowHelp = not self.D4KShowHelp;
		end;
	end;
end;



function D4KShowHelp:updateTick(dt)
end;


function D4KShowHelp:draw()
	if not self.D4KShowHelp then
		renderText(0.75, 0.25, 0.02, "Numpad 0: D4K B Info Ein");
	 else
		renderText(0.75, 0.25, 0.02, "Numpad 0: D4K B Info Aus");
		renderText(0.72, 0.68, 0.025, "- D4K B -");			
		renderText(0.72, 0.65, 0.02, "Key KP 1     : Blinker links");
		renderText(0.72, 0.63, 0.02, "Key KP 2     : Warnblinker");
		renderText(0.72, 0.61, 0.02, "Key KP 3     : Blinker rechts");
		renderText(0.72, 0.59, 0.02, "Key KP 8     : ESLimiter_Minus"); 
		renderText(0.72, 0.57, 0.02, "Key KP 9     : ESLimiter_PLUS "); 
		renderText(0.72, 0.55, 0.02, "Key 0        : Hupe"); 
		renderText(0.72, 0.53, 0.02, "Key 8        : Standgas weniger");
		renderText(0.72, 0.51, 0.02, "Key 9        : Standgas mehr");
		renderText(0.72, 0.49, 0.02, "Key Space    : Handbremse");
		renderText(0.72, 0.47, 0.02, "Key KP Enter : Motorstart");
		renderText(0.72, 0.45, 0.02, "Key -- Karl Ranseier www.ls2011.org --");
		--renderText(0.72, 0.43, 0.02, "Key 7         : Zwillingsreifen/Warntafeln");
		--renderText(0.72, 0.41, 0.02, "Key 
		--renderText(0.72, 0.39, 0.02, "Key 
		--renderText(0.72, 0.37, 0.02, "Key Home     : Rundumleuchte ");
		--renderText(0.72, 0.35, 0.02, "Key  
		--renderText(0.72, 0.33, 0.02, "Key Up        : AHK hoch");
		--renderText(0.72, 0.31, 0.02, "Key Down     : AHK runter");
		--renderText(0.72, 0.29, 0.02, "Key 
		--renderText(0.72, 0.27, 0.02, "
	end;
end;

function D4KShowHelp:onLeave()
	self.D4KShowHelp = false;
end;




