--
-- FMCMapTrigger
-- this script can play animations(by button or onEnter of trigger), play sound onEnter of trigger, play sound on animation movement and save/load animation time
--
--
-- based on MapDoorTrigger by Tobias F. (John Deere 6930)
-- author:    	Xentro (www.ls-uk.info)
-- @version:    v1.2
-- @date:       2011-12-20
-- @history:    v1.0 - inital implementation
-- 			    v1.1 - small edit for animSound 
-- 			    v1.2 - improved MP support
--              v1.2b - Fix for loadXMLFile() & createXMLFile() where first argument may not be 'nil' on a MAC.
-- 
--
FMCMapTrigger = {};
FMCMapTrigger.FMCMapTriggerLoaded = false;
FMCMapTrigger.FMCTriggers = {};

local Server_sendObjects_old = Server.sendObjects;
function Server:sendObjects(connection, x,y,z, viewDistanceCoeff)
	for _,trigger in pairs(FMCMapTrigger.FMCTriggers) do
		connection:sendEvent(setAnimationEvent:new(trigger, trigger.objActivated));
	end;
    Server_sendObjects_old(self, connection, x,y,z, viewDistanceCoeff);
end;

addModEventListener(FMCMapTrigger);

function FMCMapTrigger:loadMap(name)
    if not FMCMapTrigger.FMCMapTriggerLoaded then    
        self.oldPlayerCount = 0;
        self:loadFMCTriggerStates();
        FMCMapTrigger.FMCMapTriggerLoaded = true;
    end;
end;

function FMCMapTrigger:deleteMap()
    FMCMapTrigger.FMCMapTriggerLoaded = false;
end;

function FMCMapTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FMCMapTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function FMCMapTrigger:update(dt)
end;

function FMCMapTrigger:draw()
end;

function FMCMapTrigger:addFMCTrigger(trigger)
    table.insert(self.FMCTriggers, trigger)
end;

function FMCMapTrigger:loadFMCTriggerStates()
    if g_currentMission.missionInfo.isValid then
        local savegamePath = g_currentMission.missionInfo.savegameDirectory.."/FMCMapTriggers.XML";
        -- local savegamePath = getUserProfileAppPath() .. "savegame".. g_currentMission.missionInfo.savegameIndex .. "/FMCMapTriggers.xml";
        local xmlFile = loadXMLFile("FMCMapTriggersXML", savegamePath);
        local i = 0;
        while true do
            local triggerName = string.format("FMCMapTriggers.trigger(%d)", i);
            local name = getXMLString(xmlFile, triggerName.."#name");
            local animationTime = getXMLFloat(xmlFile, triggerName.."#animationTime");
            local bool = getXMLBool(xmlFile, triggerName.."#bool");
			local FMCTrigger = self.FMCTriggers[i+1];
            if name == nil or bool == nil or FMCTrigger == nil then
                break;
            end;
            FMCTrigger.name = name;
            FMCTrigger.bool = bool;
			if animationTime ~= nil then
				FMCTrigger.animationTime = animationTime;
			end;
            i = i + 1;
        end;
        delete(xmlFile);
    end;
end;

function FMCMapTrigger:saveFMCTriggerStates()
	local rootTag = "FMCMapTriggers";
	local xmlFile = createXMLFile("FMCMapTriggersXML", self.savegames[self.selectedIndex].savegameDirectory.."/FMCMapTriggers.XML", rootTag);
	local i=0;
	for _,v in pairs(FMCMapTrigger.FMCTriggers) do
		local tag = string.format(rootTag..".trigger(%d)", i);
		setXMLString(xmlFile, tag.."#name", v.name);
		setXMLFloat( xmlFile, tag.."#animationTime", v.animationTime);
		setXMLBool( xmlFile, tag.."#bool", v.objActivated);
		i = i + 1;
	end;
	saveXMLFile(xmlFile);
	delete(xmlFile);
end;

CareerScreen.saveSelectedGame = Utils.appendedFunction(CareerScreen.saveSelectedGame, FMCMapTrigger.saveFMCTriggerStates);

FMCTrigger = {};

local FMCTrigger_mt = Class(FMCTrigger, Object);

function onCreate(self, name)
    local instance = FMCTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(name);
    instance:register(true);
end;

function FMCTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, FMCTrigger_mt);
    self.className = "FMCTrigger";
    
    return self;
end;

function FMCTrigger:load(name)
    print("FMCMapTrigger: load("..name..")");
    
    self.triggerId = name;
	if self.isClient then
		addTrigger(name, "triggerCallback", self);
		self.isEnabled = true;
	end;
	for i=0, getNumOfChildren(name)-1 do
		local child = getChildAt(name, i);
		setCollisionMask(child, 0);
	end;
	self.assignRigidType = true;
	self.assignRigidTypeTimeOut = g_currentMission.time+4000;
	self.count = 0;
	self.playersInTrigger = {};
	self.playersLeavingTrigger = {};
	self.PIT = {};
	
    local inputKey = getUserAttribute(name, "animInputKey");
    
    local animTextNamePos = getUserAttribute(name, "animTextNamePos");
    local animTextNameNeg = getUserAttribute(name, "animTextNameNeg");
    
    if InputBinding[inputKey] ~= nil and g_i18n:hasText(animTextNamePos) and g_i18n:hasText(animTextNameNeg) then
        self.buttonActivated = true;

		self.inputKey = InputBinding[inputKey];
        self.animTextNamePos = animTextNamePos;
        self.animTextNameNeg = animTextNameNeg;
	else
        self.buttonActivated = false;
    end;
	
	self.lastanimationTime = 0;        
	self.track = false;
	local animNode = getUserAttribute(name, "animNode");
	if animNode ~= nil and string.len(animNode) >= 1 then
		local rootNode = getChild(name, animNode)
		self.animCharSet = 0;
		if rootNode ~= nil then
			self.animCharSet = getAnimCharacterSet(rootNode);
			if self.animCharSet ~= 0 then                    
				local animClip = getUserAttribute(name, "animClip");
				self.clip = getAnimClipIndex(self.animCharSet, animClip);
				if self.clip ~= nil then
					if self.clip >= 0 then
						assignAnimTrackClip(self.animCharSet, 0, self.clip);
						setAnimTrackLoopState(self.animCharSet, 0, false);
						self.speedScale = Utils.getNoNil(getUserAttribute(name, "animSpeed"), 1.0);
						self.animDuration = getAnimClipDuration(self.animCharSet, self.clip);
					end;
				else
					print("Error: Can't load animation clip, possible reason can be wrong animClip or wrong animNode");
				end;
			end;
		end;
		if self.isClient then
			local animSound = getUserAttribute(name, "animSoundPath");
			if animSound ~= nil and string.len(animSound) >= 1 then
				self.animSoundPath = g_modsDirectory.."/"..animSound;
				self.animSoundVolume = Utils.getNoNil(getUserAttribute(name, "animSoundVolume"), 1);
				self.animSoundRadius = Utils.getNoNil(getUserAttribute(name, "animSoundRadius"), 50);
				self.animSoundInnerRadius = Utils.getNoNil(getUserAttribute(name, "animSoundInnerRadius"), 10);
				self.clientAnimationSound = createAudioSource("clientAnimationSound", self.animSoundPath, self.animSoundRadius, self.animSoundInnerRadius, self.animSoundVolume, 0);
				
				link(rootNode, self.clientAnimationSound);
				setVisibility(self.clientAnimationSound, false);
				
				self.playAnimationSoundEnabled = false;
				self.animSound = true;
			else
				self.animSound = false;
			end;
		end;
	end;
		
    --[[
	local lightNode = getUserAttribute(name, "lightNode");
	if lightNode ~= nil and string.len(lightNode) >= 1 then
		local rootNode = getChild(name, lightNode)
		if rootNode ~= nil then
			self.light = rootNode;
			setVisibility(self.light, false)
			
			self.lightButtonActivated = Utils.getNoNil(getUserAttribute(name, "lightButtonActivated"), false);
			if not self.buttonActivated then self.lightButtonActivated = false; end;
			
			local maxTime = Utils.getNoNil(getUserAttribute(name, "lightTime"), 5);
			self.lightMaxTime = (1000 * maxTime);
			self.lightTimer = self.lightMaxTime;
		end;
	end;
	]]--
	if self.isClient then
		local soundPath = getUserAttribute(name, "langSoundPath");
		if soundPath ~= nil and string.len(soundPath) >= 1 then
			if getUserAttribute(name, "langSwitch") == true then
				local soundPathForLanguage = string.gsub(soundPath, "{lang}", getLanguageName(getSystemLanguage()));
				self.path = g_modsDirectory.."/"..soundPathForLanguage;
			else
				local soundPath2 = string.gsub(soundPath, "{lang}", "English");
				self.path = g_modsDirectory.."/"..soundPath2;
			end;
			self.playSound = createSample("playSound");
			if loadSample(self.playSound, self.path, false) then
				self.langSound = true;
			else
				if getUserAttribute(name, "langSwitch") == true then
					local soundPathForLanguage2 = string.gsub(soundPath, "{lang}", "English");
					local path = g_modsDirectory.."/"..soundPathForLanguage2;
					print("Changed sound path to Default (English)");
					if loadSample(self.playSound, path, false) then
						self.langSound = true;
					else
						print("Error: Sound file for onEnter couldn't be loaded.");
						self.langSound = false;
					end;
				else
					print("Error: Sound file for onEnter couldn't be loaded.");
					self.langSound = false;
				end;
			end;
			self.playSoundVolume = Utils.getNoNil(getUserAttribute(name, "langSoundVolume"), 1);
			
			self.playOnLeave = Utils.getNoNil(getUserAttribute(name, "langPlayOnLeave"), false);
		else
			self.langSound = false;
		end;
    end;
	
	self.name = getUserAttribute(name, "name");
	if self.name ~= nil and string.len(self.name) <= 0 then self.name = "noNameForTrigger"; end;
	
	self.animationTime = 0;                
	self.objActivated = false;
		
	FMCMapTrigger:addFMCTrigger(self)
end;

function FMCTrigger:delete()
    removeTrigger(self.triggerId);
    
    if self.playSound ~= nil then delete(self.playSound); end;
end;

function FMCTrigger:update(dt)	
	for i=1, table.getn(self.playersLeavingTrigger) do
		local b = self.playersLeavingTrigger[i];
		if b ~= nil then
			local v = self.playersInTrigger[b.id];
			if v ~= nil then
				if v.playerInRange ~= nil or v.vehicleInRange ~= nil then
					if self.playOnLeave ~= nil then
						if self.playOnLeave then
							self:deleteTable(b.id, i);
						else
							if v.playSoundEnabled and self.langSound then
								stopSample(self.playSound);
							end;
							self:deleteTable(b.id, i);
						end;
					else
						self:deleteTable(b.id, i);
					end;
				end;
			end;
		end;
	end;
	
	for k,v in pairs(self.playersInTrigger) do
		if (v.playerInRange ~= nil and g_currentMission.player ~= nil and v.playerInRange == g_currentMission.player.rootNode) or (v.vehicleInRange ~= nil and v.vehicleInRange:getIsActive()) then
			if self.isClient then
				if not v.playSoundEnabled and self.langSound then
					if v.playerInRange ~= nil or v.vehicleInRange:getIsActiveForSound() then
						playSample(self.playSound, 1, self.playSoundVolume, 0);
					end;
					v.playSoundEnabled = true;
				end;
				if self.buttonActivated then
					if self.clip ~= nil and self.animDuration ~= nil then--or self.light ~= nil and self.lightButtonActivated then
						if v.playerInRange ~= nil or v.vehicleInRange:getIsActiveForInput() then
							if not self.objActivated then
								g_currentMission:addHelpButtonText(g_i18n:getText(self.animTextNamePos), self.inputKey);
							else
								g_currentMission:addHelpButtonText(g_i18n:getText(self.animTextNameNeg), self.inputKey);
							end;
							if InputBinding.hasEvent(self.inputKey) then
								self:setAnimation(not self.objActivated);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	    
    if self.clip ~= nil and self.animDuration ~= nil then
		local animationEnabled = isAnimTrackEnabled(self.animCharSet, self.clip);
		if animationEnabled then
			if self.isClient then
				if not self.playAnimationSoundEnabled and self.animSound then
					setVisibility(self.clientAnimationSound, true);
					self.playAnimationSoundEnabled = true;
				end;
			end;
		else
			if self.playAnimationSoundEnabled and self.animSound then
				setVisibility(self.clientAnimationSound, false);
				self.playAnimationSoundEnabled = false;
			end;
		end;
    
        if self.animationTime <= 1 then 
            self.animationTime = 0;
            disableAnimTrack(self.animCharSet, self.clip);
            self.track = false;
        end;
        if self.animationTime >= self.animDuration then
            self.animationTime = self.animDuration;
            disableAnimTrack(self.animCharSet, self.clip);
            self.track = false;
        end;
        if self.objActivated then
            if self.animationTime < self.animDuration then
                self.animationTime = self.animationTime +self.speedScale;
            end;
        else
            if self.animationTime > 0 then
                self.animationTime = self.animationTime -self.speedScale;
            end;
        end;    
        if self.lastanimationTime ~= self.animationTime then
            if not self.track then
                enableAnimTrack(self.animCharSet, self.clip);
                self.track = true;
            end;
            setAnimTrackTime(self.animCharSet, self.clip, self.animationTime, false);
            self.lastanimationTime = self.animationTime;
        end;
    end;
	if self.isServer then
		if self.assignRigidType and self.assignRigidTypeTimeOut <= g_currentMission.time then
			for i=0, getNumOfChildren(self.triggerId)-1 do
				local child = getChildAt(self.triggerId, i)
				setCollisionMask(child, 2102);
			end;
			self.assignRigidType = false;
		end;
    end;
end;

function FMCTrigger:updateTick(dt)
	if self.isServer then
		--[[
		if self.light ~= nil then
			if self.lightButtonActivated then
				if self.objActivated then
					setVisibility(self.light, true)
				else
					setVisibility(self.light, false)
				end;
			else
				if self.playerInRange or self.vehicleInRange ~= nil then
					setVisibility(self.light, true)
					self.lightTimer = self.lightMaxTime;
				else
					self.lightTimer = self.lightTimer - dt;
					if self.lightTimer < 0 then
						setVisibility(self.light, false)
					end;
				end;
			end;
		end;
		]]--
		if not self.buttonActivated then
			if table.getn(self.PIT) > 0 then
				self:setAnimation(true);
			else
				self:setAnimation(false); 
			end;
		end;
	end;
end;

function FMCTrigger:setAnimation(state, noEventSend)
    if state ~= nil then
		self.objActivated = state;
		setAnimationEvent.sendEvent(self, state, noEventSend);
	end;
end;

function FMCTrigger:deleteTable(id, i)
	if id ~= nil and i ~= nil then
		self.playersInTrigger[id] = nil;
		table.remove(self.playersLeavingTrigger, i);
	end;
end;

function FMCTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if self.isEnabled then
		local entry = {};
		if onEnter then
			entry.playSoundEnabled = false;
			if g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node then
				entry.vehicleInRange = g_currentMission.nodeToVehicle[otherId];
				self.playersInTrigger[otherId] = entry;
				if not self.buttonActivated then table.insert(self.PIT, {id = otherId}); end;
			elseif g_currentMission.player ~= nil and g_currentMission.controlPlayer and otherId == g_currentMission.player.rootNode then
				entry.playerInRange = otherId;
				self.playersInTrigger[otherId] = entry;
				if not self.buttonActivated then table.insert(self.PIT, {id = otherId}); end;
			end;
		elseif onLeave then
			if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) or (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
				entry.id = otherId;
				table.insert(self.playersLeavingTrigger, entry);
				if not self.buttonActivated then table.remove(self.PIT); end;
			end;
		end;
	end;
end;

-- Event --
setAnimationEvent = {};
setAnimationEvent_mt = Class(setAnimationEvent, Event);

InitEventClass(setAnimationEvent, "setAnimationEvent");

function setAnimationEvent:emptyNew()
    local self = Event:new(setAnimationEvent_mt);
    self.className="setAnimationEvent";
    return self;
end;

function setAnimationEvent:new(object, state)
	local self = setAnimationEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function setAnimationEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setAnimationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function setAnimationEvent:run(connection)
	self.object:setAnimation(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setAnimationEvent:new(self.object, self.state), nil, connection, self.object);
	end;	
end;

function setAnimationEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setAnimationEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setAnimationEvent:new(vehicle, state));
		end;
	end;
end;