--TRUCK
--FazendeiroBR

TRUCK = {};

function TRUCK.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TRUCK:load(xmlFile)

    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;

	self.numbacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights = {};
    for i=1, self.numbacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;
	self.backlightsActive = false;

    local brakeSound1 = getXMLString(xmlFile, "vehicle.brakeSound1#file");
    if brakeSound1 ~= nil and brakeSound1 ~= "" then
        brakeSound1 = Utils.getFilename(brakeSound1, self.baseDirectory);
        self.brakeSound1 = createSample("brakeSound1");
        self.brakeSound1Enabled = false;
        loadSample(self.brakeSound1, brakeSound1, false);
        self.brakeSound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#pitchOffset"), 1);
        self.brakeSound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#volume"), 1);
    end;

end;

function TRUCK:delete()

    if self.brakeSound1 ~= nil then
        delete(self.brakeSound1);
    end;

end;

function TRUCK:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TRUCK:keyEvent(unicode, sym, modifier, isDown)

end;

function TRUCK:update(dt)


    if self.isEntered then

	self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;

	if self.brakelightsActive then
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive);
		end;
	else
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive, false);
		end;
	end;


	if self.backlightsActive then
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive);
		end;
	else
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive, false);
		end;
	end;

	if -self.input < -0.001 and self.movingDirection > 0 then
		self.brakelightsActive = true;
		--self.motor.brakeForce = -self.input*-50;
	elseif -self.input > 0.001 and self.movingDirection < 0 then
    		self.brakelightsActive = true;
		--self.motor.brakeForce = -self.input*25;
	else
		self.brakelightsActive = false;
		--self.motor.brakeForce = 10;
	end;
	if self.movingDirection < 0 then
    		self.backlightsActive = true;
	else
		self.backlightsActive = false;
	end;

	if self.movingDirection > 0 then
            if self.brakeSound1 ~= nil then
                if -self.input < -0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input < -0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
	if self.movingDirection < 0 then
            if self.brakeSound1 ~= nil then
                if -self.input > 0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input > 0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
    end;
end;

function TRUCK:draw()

end;

function TRUCK:onEnter()

end;

function TRUCK:onLeave()

    self.brakelightsActive = false;
    self.backlightsActive = false;

end;




