--
-- Direction Helper
--
-- @author  	Christophe Calippe
-- @version 	v1.0
-- @date  		13/09/12
-- @history:	v1.0 - Initial version
--
-- Inspiré de AICutterHelper de AICutterHelper Manuel Leithner
-- trouvé dans Krone_BigX_1100_BeastPack_V_81
--

DirectionHelper = {};

DirectionHelper.MAX_DISTANCE = 200;

function DirectionHelper.prerequisitesPresent(specializations)
    return true;
end

;

function DirectionHelper:loadMap(xmlFile)

    self.isDirectionHelperActive = false;

    if ( g_currentMission.controlledVehicle ~= nil) then
        g_currentMission.controlledVehicle.lastActiveCam = 0;
    end;

    trace("DirectionHelper:loadMap " .. xmlFile);
end

;

function DirectionHelper:load(xmlFile)
    trace("DirectionHelper:load ");
end;

function DirectionHelper:delete()
end

;

function DirectionHelper:readStream(streamId, connection)
end

;

function DirectionHelper:writeStream(streamId, connection)
end

;

function DirectionHelper:mouseEvent(posX, posY, isDown, isUp, button)
end

;

function DirectionHelper:keyEvent(unicode, sym, modifier, isDown)
    if InputBinding.isPressed(InputBinding.TOGGLE_DIRECTION_HELPER) and InputBinding.isPressed(InputBinding.Control_Gauche)
    then
        self.isDirectionHelperActive = not self.isDirectionHelperActive;
    end;
end

;

function DirectionHelper:update(dt)

    if self.isDirectionHelperActive then

        if g_currentMission.controlledVehicle ~= nil then

            if g_currentMission.controlledVehicle.setBackupCam ~= nil and g_currentMission.controlledVehicle.currentCam ~= 0 then
                g_currentMission.controlledVehicle.lastActiveCam = g_currentMission.controlledVehicle.currentCam
                g_currentMission.controlledVehicle:setBackupCam(0);
            else
                if g_currentMission.controlledVehicle.lastActiveCam ~= 0 and g_currentMission.controlledVehicle.setBackupCam ~= nil and g_currentMission.controlledVehicle.currentCam == 0 then
                    if g_currentMission.controlledVehicle.panel.isOpen then
                        g_currentMission.controlledVehicle:setBackupCam(g_currentMission.controlledVehicle.lastActiveCam);
                        g_currentMission.controlledVehicle.lastActiveCam = 0;
                    else
                        g_currentMission.controlledVehicle.lastActiveCam = 0;
                    end;
                end;
            end;


            -- disable cams
            if g_currentMission.controlledVehicle.setBackupCam ~= nil and g_currentMission.controlledVehicle.currentCam ~= 0 then
                g_currentMission.controlledVehicle:setBackupCam(0);
            end;

            local offset = 0.2;
            local r, g, b = 1, 0, 0;
            local length = 20;
            local dirX, dirY, dirZ = localDirectionToWorld(g_currentMission.controlledVehicle.rootNode, 0, 0, 1);

            local lx1, ly1, lz1 = getWorldTranslation(g_currentMission.controlledVehicle.rootNode);

            ly1 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx1, ly1, lz1) + offset;

            local lx2, ly2, lz2 = nil, nil, nil;

            for i = 0, math.floor(DirectionHelper.MAX_DISTANCE / length) + 2 do
                lx2 = lx1 + (dirX * length);
                ly2 = ly1 + (dirY * length);
                lz2 = lz1 + (dirZ * length);

                ly2 = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, lx2, ly2, lz2) + offset;

                drawDebugLine(lx1, ly1, lz1, r, g, b, lx2, ly2, lz2, r, g, b);


                lx1 = lx2;
                ly1 = ly2;
                lz1 = lz2;
            end;
        end;
    end;
end

;

function DirectionHelper:updateTick(dt)
end

;

function DirectionHelper:draw()

    if g_currentMission.controlledVehicle ~= nil then

        local texte = " Direction Helper (Press left CTRL)";

        if self.isDirectionHelperActive then
            texte = "Disable" .. texte;
        else
            texte = "Enable" .. texte;
        end;

        g_currentMission:addHelpButtonText(texte, InputBinding.TOGGLE_DIRECTION_HELPER);
    end;
end

;

--
-- trace
--
function trace(message)

    local fichier = io.open(getUserProfileAppPath() .. "trace.txt", "a");
    if fichier ~= nil then
        fichier:write(message .. "\n");
        fichier:flush();
        fichier:close();
    end;
end


addModEventListener(DirectionHelper);