-- Fendt615LSA
-- Specialisation for the Fendt 615 LSA
--
-- by fruktor
-- www.eifok-team.de
-- 

Fendt615LSA = {};

function Fendt615LSA.initSpecialization()
	--Vehicle.registerJointType("jd_frontCoupler");
	--Vehicle.registerJointType("jd_weight");
	--Vehicle.registerJointType("jd_fastCoupler");
end;

function Fendt615LSA.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Fendt615LSA:load(xmlFile)	
	self.getIsTurnedOnAttachedImplements = Fendt615LSA.getIsTurnedOnAttachedImplements;

	self.rearAttacherJoint = {};
	self.rearAttacherJoint.mainPullerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#mainPullerIndex"));
	self.rearAttacherJoint.orientNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#orientIndex"));	
	
	self.trailerAttacherRotateNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherRotateNode#index") );

	self.internalCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.internalCamera#index"));
	self.camPositionX = 0;
	self.camPositionZ = 0;
	
	self.lightSpecialTG = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.lightSpecial#indexTG") );
	self.lightSpecialPolyN = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.lightSpecial#indexPoly") );	-- not used
	self.lightSpecialCoronaN = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.lightSpecial#indexCoronaN") );
	self.lightSpecialCoronaW1 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.lightSpecial#indexCoronaW1") );
	self.lightSpecialCoronaW2 = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.lightSpecial#indexCoronaW2") );
	self.lightSpecialState = false;
	
	self.setSpecialLight = SpecializationUtil.callSpecializationsFunction("setSpecialLight");
	self:setSpecialLight( false, true );
end;

function Fendt615LSA:delete()
end;

function Fendt615LSA:getIsTurnedOnAttachedImplements()
	for _,v in pairs(self.attachedImplements) do
		if v.object.isTurnedOn ~= nil then
			if v.object.isTurnedOn == true then
				return true;
			end;
		end;
	end;
	return false
end;

function Fendt615LSA:readStream(streamId, connection)
end;

function Fendt615LSA:writeStream(streamId, connection)	
end;

function Fendt615LSA:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt615LSA:keyEvent(unicode, sym, modifier, isDown)
	if bitAND(modifier, Input.MOD_CTRL) > 0 and bitAND(modifier, Input.MOD_ALT) > 0 and InputBinding.isPressed(InputBinding.FENDT615LSA_SpecialLight) then
		self:setSpecialLight( not self.specialLightState );
	end;
end;

function Fendt615LSA:update(dt)
	
	if self.isEntered then
		
		if InputBinding.isPressed(InputBinding.MOVECAMLEFT) then
			self.camPositionX = self.camPositionX + 0.02;
			if self.camPositionX >= 0.3 then
				self.camPositionX = 0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMRIGHT) then
			self.camPositionX = self.camPositionX - 0.02;
			if self.camPositionX <= -0.3 then
				self.camPositionX = -0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMFORWARD) then
			self.camPositionZ = self.camPositionZ + 0.02;
			if self.camPositionZ >= 0.3 then
				self.camPositionZ = 0.3;
			end;
		end;
		
		if InputBinding.isPressed(InputBinding.MOVECAMBACK) then
			self.camPositionZ = self.camPositionZ - 0.02;
			if self.camPositionZ <= -0.3 then
				self.camPositionZ = -0.3;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.MOVECAMRESET) then
			self.camPositionX = 0;
			self.camPositionZ = 0;
		end;
		
		if self.internalCamera ~= nil then
			setTranslation(self.internalCamera, self.camPositionX, 0, self.camPositionZ);
		end;		
	end;	

	if self.checkTrailerAttacherRot == true then 
		if self.attacherJoints[1].jointIndex ~= 0 or
			self.attacherJoints[3].jointIndex ~= 0 or
			self.attacherJoints[5].jointIndex ~= 0 then		
			setRotation(self.trailerAttacherRotateNode, 0, Utils.degToRad(-180), 0);
		else
			setRotation(self.trailerAttacherRotateNode, 0, 0, 0);
		end;	
		checkTrailerAttacherRot = false;
	end;
end;

function Fendt615LSA:updateTick(dt)
	--used to get more updateIntervales then updateTick()
	if not self.startedUpdating then
		self.updateInterval = self.time+10;
		self.startedUpdating = true;
	end;
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;
		if self.rearAttacherJoint.mainPullerNode ~= nil and self.rearAttacherJoint.orientNode ~= nil then
			local x,_,_ = getRotation(self.rearAttacherJoint.orientNode)
			local _,y,z = getRotation(self.rearAttacherJoint.mainPullerNode)
			setRotation(self.rearAttacherJoint.mainPullerNode, x,y,z);
		end;
		if self.specialLightState == true then
			if self.lightsActive == true then
				setVisibility( self.lightSpecialCoronaN, true );
			else
				setVisibility( self.lightSpecialCoronaN, false );
			end;
			if self.B3 ~= nil then
				if self.B3.work ~= nil then
					if self.B3.work[1].a then
						setVisibility( self.lightSpecialCoronaW1, true );
					else
						setVisibility( self.lightSpecialCoronaW1, false );
					end;
					if self.B3.work[2].a then
						setVisibility( self.lightSpecialCoronaW2, true );
					else
						setVisibility( self.lightSpecialCoronaW2, false );
					end;
				end;
			end;			
		end;
	end;
end;

function Fendt615LSA:draw()
end;

function Fendt615LSA:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Fendt615LSA:getSaveAttributesAndNodes(nodeIdent)
end;

function Fendt615LSA:attachImplement(implement)	
	self.checkTrailerAttacherRot = true;
end;

function Fendt615LSA:detachImplement(implementIndex)
	self.checkTrailerAttacherRot = true;
end;

function Fendt615LSA:setSpecialLight(state, noEventSend)
	SpecialLightEvent.sendEvent(self, state, noEventSend);
	self.specialLightState = state;
	if self.lightsActive == true then
		setVisibility( self.lightSpecialCoronaN, true );
	else
		setVisibility( self.lightSpecialCoronaN, false );
	end;	
	if self.B3 ~= nil then
		if self.B3.work ~= nil then
			if self.B3.work[1].a then
				setVisibility( self.lightSpecialCoronaW1, true );
			else
				setVisibility( self.lightSpecialCoronaW1, false );
			end;
			if self.B3.work[2].a then
				setVisibility( self.lightSpecialCoronaW2, true );
			else
				setVisibility( self.lightSpecialCoronaW2, false );
			end;
		end;
	end;
	setVisibility( self.lightSpecialTG, state );
end;

--
SpecialLightEvent = {};
SpecialLightEvent_mt = Class(SpecialLightEvent, Event);

InitEventClass(SpecialLightEvent, "SpecialLightEvent");

function SpecialLightEvent:emptyNew()
    local self = Event:new(SpecialLightEvent_mt);
    self.className="SpecialLightEvent";
    return self;
end;

function SpecialLightEvent:new(vehicle, state)
    local self = SpecialLightEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function SpecialLightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SpecialLightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SpecialLightEvent:run(connection)
	self.vehicle:setSpecialLight(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SpecialLightEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SpecialLightEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false and 
		vehicle.specialLightState ~= state then
		if g_server ~= nil then
			g_server:broadcastEvent(SpecialLightEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SpecialLightEvent:new(vehicle, state));
		end;
	end;
end;