--
-- AutoSteerBack
-- Specialization for stopping auto steer back
--
-- @author    PES 4ever
-- @date      02/09/11
-- @version   1.0
--
-- For support and documentation visit www.modding-society.de
-- Copyright (C) PES 4ever, All Rights Reserved.
--

AutoSteerBack = {};

function AutoSteerBack.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function AutoSteerBack:load(xmlFile)

	self.setIsAutoSteerBackStopped = SpecializationUtil.callSpecializationsFunction("setIsAutoSteerBackStopped");

	-- Steering auto rotate back
	self.autoSteerBack = {};
	self.autoSteerBack.isStopped = false;
	self.autoSteerBack.maxRotatedTimeSpeedSave = self.maxRotatedTimeSpeed;
	
end;

function AutoSteerBack:delete()
end;

function AutoSteerBack:readStream(streamId, connection)
    local isStopped = streamReadBool(streamId);
    self:setIsAutoSteerBackStopped(isStopped, true);
end;

function AutoSteerBack:writeStream(streamId, connection)
	streamWriteBool(streamId, self.autoSteerBack.isStopped);
end;

function AutoSteerBack:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutoSteerBack:keyEvent(unicode, sym, modifier, isDown)
end;

function AutoSteerBack:update(dt)

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_AUTOSTEERBACK) then
			self:setIsAutoSteerBackStopped(not self.autoSteerBack.isStopped);
		end;
	end;
	
end;

function AutoSteerBack:updateTick(dt)
end;

function AutoSteerBack:draw()

	-- Auto steer back help text
	g_currentMission:addHelpButtonText(g_i18n:getText("TOGGLE_AUTOSTEERBACK"), InputBinding.TOGGLE_AUTOSTEERBACK);

end;

function AutoSteerBack:setIsAutoSteerBackStopped(isStopped, noEventSend)
    
	if isStopped ~= self.autoSteerBack.isStopped then
		SetIsAutoSteerBackStoppedEvent.sendEvent(self, isStopped, noEventSend);
		self.autoSteerBack.isStopped = isStopped;
		if self.autoSteerBack.isStopped then
			self.maxRotatedTimeSpeed = 0;
		else
			self.maxRotatedTimeSpeed = self.autoSteerBack.maxRotatedTimeSpeedSave;
		end;
	end;
	
end;

function AutoSteerBack:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local autoSteerBackStopped = Utils.getNoNil(getXMLBool(xmlFile, key .. "#autoSteerBackStopped"), false);
		self:setIsAutoSteerBackStopped(autoSteerBackStopped);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function AutoSteerBack:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'autoSteerBackStopped="' .. tostring(self.autoSteerBack.isStopped) .. '"';
	return attributes, nil;
end;