--
-- SDF
-- Specialization class for SDF group
--
-- @author  Ago-Systemtech
-- @date  17/11/2011
-- Copyright (C) Ago-Systemtech, All Rights Reserved.

SDFmod = {};

function SDFmod.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SDFmod:load(xmlFile)
	
	---Panel--
	self.controlpath = Utils.getFilename("Textur/info.png", self.baseDirectory);
    self.helpPoxX = 0.70;
    self.helpPoxY = 0.22;
    self.helpWidth = 0.30;
    self.helpHeight = 0.66;
    self.helpOverlay = Overlay:new("info", self.controlpath, self.helpPoxX, self.helpPoxY, self.helpWidth, self.helpHeight);
    self.InfoAttiva = true;
	
	self.ledriserva = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 100;
	self.prevousFuelPercentage = 0;
    self.handbrake = true;
	self.cos = 20000;
	self.druckLevel = 10000; 
	
	   --HandBrake--
	self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
    self.brakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brakelight#index"));
	self.reverselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reverselight#index"));
	
	handbrakeSoundFile = Utils.getFilename("sound/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("sound/handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("sound/brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("sound/brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("sound/brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("sound/brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
		
	compressorSoundFile = Utils.getFilename("sound/compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("sound/compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("sound/compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("sound/compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
	   --HandBrake Fine--
	   
	   ----led---
	self.batteriaicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batteriaicona#index")); 
	self.olioicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.olioicona#index")); 
	self.tachiicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tachiicona#index")); 
	 
       --Hydraulic--
    self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));

        --Parafanghi--
	self.fender = {};
	self.fender.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#leftIndex"));
	self.fender.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#rightIndex"));
	self.fender.leftRotMax = getXMLInt(xmlFile, "vehicle.fender#leftRotMax");
	self.fender.rightRotMax = getXMLInt(xmlFile, "vehicle.fender#rightRotMax");
 
        --Inclinazione ruote--
   -- self.GommeLK = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommeLK#index"));
   -- self.GommeRK = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommeRK#index"));
   -- self.GommePoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Gommes.GommePoint#index"));
	
	   --BGA silos--
     self.bunkerSiloCompactingScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.bunkerSiloCompacter#compactingScale"), 1);
     self.bunkerSiloCompactingRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bunkerSiloCompacter#refNode"));

	   
        --Power Shaft--
	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;
      --Power Shaft Fine--
	       
    	
   
	local rotationPartNodeContagiri = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartContagiri#index"));
    if rotationPartNodeContagiri ~= nil then
        self.rotationPartContagiri = {};
        self.rotationPartContagiri.node = rotationPartNodeContagiri;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#minRot"));
        self.rotationPartContagiri.minRot = {};
        self.rotationPartContagiri.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartContagiri#maxRot"));
        self.rotationPartContagiri.maxRot = {};
        self.rotationPartContagiri.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartContagiri.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartContagiri.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartContagiri.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#rotTime"), 2)*1000;
        self.rotationPartContagiri.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartContagiri#touchRotLimit"), 10));
    end;
	
		
	local rotationPartNodeKmh1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;
	
		
	      -- Indicatori--
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	

	
	fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	self.helpPanel = false;
	self.helpPanel = false;
end;

function SDFmod:stopMotor()
    self.motor.minRpm = 200;
end;

function SDFmod:delete()

end;

function SDFmod:mouseEvent(posX, posY, isDown, isUp, button)

end;

function SDFmod:keyEvent(unicode, sym, modifier, isDown)
	
		
	   ---Help--
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	  	
     	--panel--
		if isDown and sym == Input.KEY_f12 then
		self.InfoAttiva = not self.InfoAttiva;
	end;
	
	    --HandBrake---
	if isDown and sym == Input.KEY_space then
		self.handbrake = not self.handbrake; 
		if self.handbrake then
			playSample(self.handbrakeSoundId,1,1,0);
			brakeTorque = 600;
			self.motor.brakeForce = brakeTorque;
		end;
	end;
	
	
	
end;

function SDFmod:update(dt)
	


	    	    --pistoni sollevatore--
		for i=1,table.getn(self.movingParts) do
			Cylindered.updateMovingPart(self, self.movingParts[i]);
		end;
                  
				--parafanghi--
	    if self:getIsActive() then
		
		local x1,y1,z1 = getRotation(self.wheels[1].repr);
		if y1 < math.rad(self.fender.rightRotMax) then
			setRotation(self.fender.rightNode, 0, math.rad(10), 0);
		else
			setRotation(self.fender.rightNode, 0, 0, 0);
		end;
		
		local x2,y2,z2 = getRotation(self.wheels[2].repr);
		if y2 > math.rad(self.fender.leftRotMax) then
			setRotation(self.fender.leftNode, 0, math.rad(-10), 0);
		else
			setRotation(self.fender.leftNode, 0, 0, 0);
		end;
	
	end;
           			
			--Inclinazione ruote--
--	if self:getIsActive() then
--		self.GetRotRT, self.GetRotRTT, self.GetRotRTTT = getRotation(self.GommePoint)
--		self.RotateF = (self.GetRotRTT /30) 
--		setRotation(self.GommeLK, 0, 0, -self.RotateF)		
--		setRotation(self.GommeRK, 0, 0, -self.RotateF)		   		
--	end;
	     			
			--RPM control--
	if self:getIsActiveForInput() then
        if Input.isKeyPressed(Input.KEY_k) then
		    self.motor.minRpm = self.motor.minRpm - 10;
		elseif Input.isKeyPressed(Input.KEY_m) then
		    self.motor.minRpm = self.motor.minRpm + 10;
	    end;
    end;

    if self.isEntered then
		if self.motor.minRpm < -1600 then
			self.motor.minRpm = -1600;
		elseif self.motor.minRpm > 100 then
			self.motor.minRpm = 100;
		end;
	end;

	
          -- Indication ---
	if self.isMotorStarted then
		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;

	else
		setRotation(self.rotationPartTanknadel.node, 0, 0 , 0);
	end;
	
		
  local maxContagiri = 2400;
  if self.isMotorStarted then
	if self.rotationPartContagiri ~= nil then
		local x, y, z = getRotation(self.rotationPartContagiri.node);
		y = ((self.rotationPartContagiri.maxRot[2] - self.rotationPartContagiri.minRot[2]) / maxContagiri) * self.motor.lastMotorRpm + self.rotationPartContagiri.minRot[2];
		setRotation(self.rotationPartContagiri.node, x, y ,z);
	end;
	else
		setRotation(self.rotationPartContagiri.node, 0, 0 , 0);
	end;
		
	local maxKmh = 68;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;

	
	if self.isEntered then
		if self.fuelFillLevel < 50 then
			self.riserva = self.riserva - dt;
			if self.riserva <= 0 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.riserva = 30000;
			end;
			self.ledriservaActive = true;
		else
			self.riserva = 30000;
			self.ledriservaActive = false;
		end;
		setVisibility(self.ledriserva,self.ledriservaActive);
	end;

	
		
				--Hydraulic--
    if self:getIsActive() then
        if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);
		end;
	end;
	
	        --HandBrake---
	if self.isEntered then

        
        if g_currentMission.allowSteerableMoving and not self.playMotorSound then
			
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0, true)
			end;
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0,true)
			end;
			
        if self.fuelFillLevel == 0 then
            acceleration = 0;
          end;
					
		end;
		
		if not self.handbrake then
		    brakeTorque = 20;
			self.motor.brakeForce = brakeTorque;
			setVisibility(self.handbrakelight, false);
		else
			if not Input.isKeyPressed(Input.KEY_s) then
				setVisibility(self.handbrakelight, true);
			end;
		end;		
		if Input.isKeyPressed(Input.KEY_s) then
			if not self.druckWarning then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -350;
					else
						self.druckLevel = self.druckLevel -250;
					end;
					self.braking = true;
				end;
				setVisibility(self.brakelight, true);
				if not self.brakePlaying then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			setVisibility(self.brakelight, false);
			self.braking = false;
			if not self.handbrake then
				brakeTorque = 20;
				self.motor.brakeForce = brakeTorque;
			end;
			if not self.brakereleasePlaying then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

		
				
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
	end;
	
		    
	   
end;

function SDFmod:updateTick(dt)

    if self:getIsActive() then	
					
			
		if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
		end;
				
	end;
	
end;

function SDFmod:draw()
      
	  if self.helpOverlay ~= nil then
		if self.InfoAttiva then
		self.helpOverlay:render();
		end;
	end;
		if self.InfoAttiva then	
			--g_currentMission:addExtraPrintText("Key F12: Info Off");
		else
			---g_currentMission:addExtraPrintText("Key F12: Info On");
		end;

	if self.isEntered then
		if not self.helpPanel then
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info On");
		else
			--renderText(0.72, 0.25, 0.02, "Tasto m: Info Off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.56, 0.023, "      - Help -   ");
			renderText(0.02, 0.54, 0.021, "Prima di agganciare un rimorchio regolare l'altezza del gancio");
			renderText(0.02, 0.52, 0.021, "Before attaching a trailer to adjust the height of the hook");
			renderText(0.02, 0.50, 0.021, "Vor dem Anbringen eines Anhangers, die Hohe des Hakens.");
			renderText(0.02, 0.48, 0.021, "      ---------------------------------");
			renderText(0.02, 0.46, 0.021, "Il trattore lavabile e si sporca dopo circa un ora di gioco.");
			renderText(0.02, 0.44, 0.021, "Si puo lavare e si pulisce anche con la pioggia.");
			renderText(0.02, 0.42, 0.021, "The tractor is washable and it gets dirty after about an hour of play.");
			renderText(0.02, 0.40, 0.021, "You can wash and clean even with the rain.");
			renderText(0.02, 0.38, 0.021, "Der Traktor ist waschbar und es wird schmutzig nach etwa einer Stunde zu spielen.");
			renderText(0.02, 0.36, 0.021, "Sie konnen waschen und zu reinigen, auch mit dem regen.");
			renderText(0.02, 0.34, 0.021, "      ---------------------------------");
			renderText(0.02, 0.32, 0.021, "Per usare il limitatore di giri ESLimiter, premere i tasti Pgup/Pgdown");
			renderText(0.02, 0.30, 0.021, "To use the rev limiter ESLimiter, press the PgUp / PgDown");
			renderText(0.02, 0.28, 0.021, "Zur Verwendung der Drehzahlbegrenzer ESLimiter, drucken Sie die Bild auf / Bild ab");
			renderText(0.02, 0.26, 0.021, "      ---------------------------------");
			renderText(0.02, 0.24, 0.021, "Grazie per aver scelto una mia mod-Thank you for my mod-Vielen Dank fur meine mod");
			renderText(0.02, 0.22, 0.021, "Support, TRACTOR ITALIA FORUM: http://forum.tractor-italia.net");
			renderText(0.02, 0.20, 0.021, "ATTENZIONE VIETATO FARE MODIFICHE-ATTENTION, FORBIDDEN TO DO CHANGES.");
			renderText(0.02, 0.18, 0.021, "Creative Commons license, by Ago-Systemtech");
		end;
	end;
	
	if self.isEntered then
		if self.hudjohndeereOverlay ~= nil then
			self.hudjohndeereOverlay:render();
		end;
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(0.74, 0.26, 0.02, "Handbremse loesen! Space");
			end;
			renderText(0.74, 0.22, 0.02, "(!) Handbremse aktiv (!)");	
		end;
		
		if self.druckWarning then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.74, 0.40, 0.02, "   Systemdruck zu gering.");
			renderText(0.74, 0.37, 0.02, "   Eingeschraenkte Bremswirkung!");
		end;
	end;
	
	
end;

function SDFmod:onEnter()
        if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
		end
	
end;

function SDFmod:onLeave()
         self.motor.minRpm = 200;
		 
	if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.tachiicona, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.tachiicona, false);
		end
end;

