--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.76, 0.21, 0.021, "InTrac 6.60: Info Aus");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.76, 0.21, 0.021, "InTrac 6.60: Info An");
		renderText(0.72, 0.86, 0.025, "Deutz-Fahr InTrac 6.60 Info");			
                renderText(0.72, 0.81, 0.02, "Numpad 1: Blinker links");
		renderText(0.72, 0.79, 0.02, "Numpad 2: Warnblinker");
		renderText(0.72, 0.77, 0.02, "Numpad 3: Blinker rechts");		
		renderText(0.72, 0.75, 0.02, "Numpad 4: Tuer oeffnen");
		renderText(0.72, 0.73, 0.02, "Numpad 5: Heckscheibe");
		renderText(0.72, 0.71, 0.02, "Numpad 7: Allrad");
		renderText(0.72, 0.69, 0.02, "Numpad 8: Arbeitslicht Vorne");	
		renderText(0.72, 0.67, 0.02, "Numpad 9: Arbeitslicht Heck");
		renderText(0.72, 0.65, 0.02, "Taste PageUp: Kuplung Hoch");
		renderText(0.72, 0.63, 0.02, "Taste PageDown: Kupplung Runter");
		renderText(0.72, 0.61, 0.02, "Taste 5: Seitenfenster Links");
		renderText(0.72, 0.59, 0.02, "Taste 6: Seitenfenster1 Rechts");
		renderText(0.72, 0.57, 0.02, "Taste 7: Seitenfenster2 Rechts");
		renderText(0.72, 0.55, 0.02, "Taste 8: Dachluke");
		renderText(0.72, 0.53, 0.02, "Taste 9: Motorklappen");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




