--
-- Ovi- ja ikkunascripti
-- 
--
-- @author  	tvaltra
-- @version 	1.0
-- @date  		15.7.2012
--

Ovet = {};

function Ovet.prerequisitesPresent(specializations)
    return true
end;

function Ovet:load(xmlFile)

	self.setVasOviAuki = SpecializationUtil.callSpecializationsFunction("setVasOviAuki");
	self.setOikOviAuki = SpecializationUtil.callSpecializationsFunction("setOikOviAuki");
	self.setIkkunaAuki = SpecializationUtil.callSpecializationsFunction("setIkkunaAuki");
	self.setSivuIkkuna1Auki = SpecializationUtil.callSpecializationsFunction("setSivuIkkuna1Auki");
	self.setSivuIkkuna2Auki = SpecializationUtil.callSpecializationsFunction("setSivuIkkuna2Auki");
	self.setLuukkuAuki = SpecializationUtil.callSpecializationsFunction("setLuukkuAuki");

	self.vasenovi = {};
	self.vasenovi.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#vasen"));
	self.vasenovi.minRot = {};
			self.vasenovi.minRot[1] = Utils.degToRad(0);
			self.vasenovi.minRot[2] = Utils.degToRad(0);
			self.vasenovi.minRot[3] = Utils.degToRad(0);
			self.vasenovi.maxRot = {};
			self.vasenovi.maxRot[1] = Utils.degToRad(0);
			self.vasenovi.maxRot[2] = Utils.degToRad(35);
			self.vasenovi.maxRot[3] = Utils.degToRad(0);
			self.vasenovi.rotTime = 5000;
			self.vasenovi.touchRotLimit = 10;
			
	self.oikeaovi = {};
	self.oikeaovi.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#oikea"));
	self.oikeaovi.minRot = {};
			self.oikeaovi.minRot[1] = Utils.degToRad(0);
			self.oikeaovi.minRot[2] = Utils.degToRad(-35);
			self.oikeaovi.minRot[3] = Utils.degToRad(0);
			self.oikeaovi.maxRot = {};
			self.oikeaovi.maxRot[1] = Utils.degToRad(0);
			self.oikeaovi.maxRot[2] = Utils.degToRad(0);
			self.oikeaovi.maxRot[3] = Utils.degToRad(0);
			self.oikeaovi.rotTime = 5000;
			self.oikeaovi.touchRotLimit = 10;
			
	self.takaikkuna = {};
	self.takaikkuna.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#ikkuna"));
	self.takaikkuna.minRot = {};
			self.takaikkuna.minRot[1] = Utils.degToRad(0);
			self.takaikkuna.minRot[2] = Utils.degToRad(0);
			self.takaikkuna.minRot[3] = Utils.degToRad(0);
			self.takaikkuna.maxRot = {};
			self.takaikkuna.maxRot[1] = Utils.degToRad(65);
			self.takaikkuna.maxRot[2] = Utils.degToRad(0);
			self.takaikkuna.maxRot[3] = Utils.degToRad(0);
			self.takaikkuna.rotTime = 5000;
			self.takaikkuna.touchRotLimit = 10;
			
			self.sivuikkuna1 = {};
	self.sivuikkuna1.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#sivuikkuna1"));
	self.sivuikkuna1.minRot = {};
			self.sivuikkuna1.minRot[1] = Utils.degToRad(0);
			self.sivuikkuna1.minRot[2] = Utils.degToRad(0);
			self.sivuikkuna1.minRot[3] = Utils.degToRad(-15);
			self.sivuikkuna1.maxRot = {};
			self.sivuikkuna1.maxRot[1] = Utils.degToRad(0);
			self.sivuikkuna1.maxRot[2] = Utils.degToRad(0);
			self.sivuikkuna1.maxRot[3] = Utils.degToRad(0);
			self.sivuikkuna1.rotTime = 5000;
			self.sivuikkuna1.touchRotLimit = 10;
			
			self.sivuikkuna2 = {};
	self.sivuikkuna2.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#sivuikkuna2"));
	self.sivuikkuna2.minRot = {};
			self.sivuikkuna2.minRot[1] = Utils.degToRad(0);
			self.sivuikkuna2.minRot[2] = Utils.degToRad(0);
			self.sivuikkuna2.minRot[3] = Utils.degToRad(0);
			self.sivuikkuna2.maxRot = {};
			self.sivuikkuna2.maxRot[1] = Utils.degToRad(0);
			self.sivuikkuna2.maxRot[2] = Utils.degToRad(0);
			self.sivuikkuna2.maxRot[3] = Utils.degToRad(15);
			self.sivuikkuna2.rotTime = 5000;
			self.sivuikkuna2.touchRotLimit = 10;
			
			self.kattoluukku = {};
	self.kattoluukku.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ovet#luukku"));
	self.kattoluukku.minRot = {};
			self.kattoluukku.minRot[1] = Utils.degToRad(0);
			self.kattoluukku.minRot[2] = Utils.degToRad(0);
			self.kattoluukku.minRot[3] = Utils.degToRad(0);
			self.kattoluukku.maxRot = {};
			self.kattoluukku.maxRot[1] = Utils.degToRad(20);
			self.kattoluukku.maxRot[2] = Utils.degToRad(0);
			self.kattoluukku.maxRot[3] = Utils.degToRad(0);
			self.kattoluukku.rotTime = 5000;
			self.kattoluukku.touchRotLimit = 10;
			
	
	self.vasovi = false;
	self.oikovi = true;
	self.ikkuna = false;
	self.sivuikkuna1a = true;
	self.sivuikkuna2a = false;
	self.luukku = false;
	
	

end;

function Ovet:delete()
end;

function Ovet:readStream(streamId, connection)
    local vasAuki = streamReadBool(streamId);
    self:setVasOviAuki(vasAuki, true);
	local okiAuki = streamReadBool(streamId);
    self:setOikOviAuki(oikAuki, true);
	local ikkunaAuki = streamReadBool(streamId);
    self:setIkkunaAuki(ikkunaAuki, true);
	local sivuikkuna1Auki = streamReadBool(streamId);
    self:setSivuIkkuna1Auki(sivuikkuna1Auki, true);
	local sivuikkuna2Auki = streamReadBool(streamId);
    self:setSivuIkkuna2Auki(sivuikkuna2Auki, true);
	local luukkuAuki = streamReadBool(streamId);
    self:setLuukkuAuki(luukkuAuki, true);
end;

function Ovet:writeStream(streamId, connection)
    streamWriteBool(streamId, self.vasovi);
	streamWriteBool(streamId, self.oikovi);
	streamWriteBool(streamId, self.ikkuna);
	streamWriteBool(streamId, self.sivuikkuna1a);
	streamWriteBool(streamId, self.sivuikkuna2a);
	streamWriteBool(streamId, self.luukku);
end;

function Ovet:readUpdateStream(streamId, timestamp, connection)
end;

function Ovet:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Ovet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ovet:keyEvent(unicode, sym, modifier, isDown)
end;

function Ovet:update(dt)	
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.vasenovi) then
			self:setVasOviAuki(not self.vasovi);
		end;
		if InputBinding.hasEvent(InputBinding.oikeaovi) then
			self:setOikOviAuki(not self.oikovi);
		end;
		if InputBinding.hasEvent(InputBinding.takaikkuna) then
			self:setIkkunaAuki(not self.ikkuna);
		end;
		if InputBinding.hasEvent(InputBinding.sivuikkuna1) then
			self:setSivuIkkuna1Auki(not self.sivuikkuna1a);
		end;
		if InputBinding.hasEvent(InputBinding.sivuikkuna2) then
			self:setSivuIkkuna2Auki(not self.sivuikkuna2a);
		end;
		if InputBinding.hasEvent(InputBinding.luukku) then
			self:setLuukkuAuki(not self.luukku);
		end;
    end;
end;

function Ovet:updateTick(dt)	
	if self:getIsActive() then	
		
		if self.isServer then
		if self.vasenovi.index ~= nil then 
		local x, y, z = getRotation(self.vasenovi.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.vasenovi.maxRot, self.vasenovi.minRot, 3, self.vasenovi.rotTime, dt, not self.vasovi); 
		setRotation(self.vasenovi.index, unpack(newRot)); 
	end;	
	
	if self.oikeaovi.index ~= nil then 
		local x, y, z = getRotation(self.oikeaovi.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.oikeaovi.maxRot, self.oikeaovi.minRot, 3, self.oikeaovi.rotTime, dt, not self.oikovi); 
		setRotation(self.oikeaovi.index, unpack(newRot)); 
	end;	
	
	if self.takaikkuna.index ~= nil then 
		local x, y, z = getRotation(self.takaikkuna.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.takaikkuna.maxRot, self.takaikkuna.minRot, 3, self.takaikkuna.rotTime, dt, not self.ikkuna); 
		setRotation(self.takaikkuna.index, unpack(newRot)); 
	end;	
	
	if self.sivuikkuna1.index ~= nil then 
		local x, y, z = getRotation(self.sivuikkuna1.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.sivuikkuna1.maxRot, self.sivuikkuna1.minRot, 3, self.sivuikkuna1.rotTime, dt, not self.sivuikkuna1a); 
		setRotation(self.sivuikkuna1.index, unpack(newRot)); 
	end;	
	
	if self.sivuikkuna2.index ~= nil then 
		local x, y, z = getRotation(self.sivuikkuna2.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.sivuikkuna2.maxRot, self.sivuikkuna2.minRot, 3, self.sivuikkuna2.rotTime, dt, not self.sivuikkuna2a); 
		setRotation(self.sivuikkuna2.index, unpack(newRot)); 
	end;	
	
	if self.kattoluukku.index ~= nil then 
		local x, y, z = getRotation(self.kattoluukku.index); 
		local rot = {x,y,z}; 
		local newRot = Utils.getMovedLimitedValues(rot, self.kattoluukku.maxRot, self.kattoluukku.minRot, 3, self.kattoluukku.rotTime, dt, not self.luukku); 
		setRotation(self.kattoluukku.index, unpack(newRot)); 
	end;	
	
			
		end;
	end;	
end;

function Ovet:draw()
	
end;

function Ovet:setVasOviAuki(vasAuki, noEventSend)
    SetOviEvent.sendEvent(self, vasAuki, noEventSend);
    self.vasovi = vasAuki;
end;

function Ovet:setOikOviAuki(oikAuki, noEventSend)
    SetOviEvent.sendEvent(self, oikAuki, noEventSend);
    self.oikovi = oikAuki;
end;

function Ovet:setIkkunaAuki(ikkunaAuki, noEventSend)
    SetOviEvent.sendEvent(self, ikkunaAuki, noEventSend);
    self.ikkuna = ikkunaAuki;
end;

function Ovet:setSivuIkkuna1Auki(sivuikkuna1Auki, noEventSend)
    SetOviEvent.sendEvent(self, sivuikkuna1Auki, noEventSend);
    self.sivuikkuna1a = sivuikkuna1Auki;
end;

function Ovet:setSivuIkkuna2Auki(sivuikkuna2Auki, noEventSend)
    SetOviEvent.sendEvent(self, sivuikkuna2Auki, noEventSend);
    self.sivuikkuna2a = sivuikkuna2Auki;
end;

function Ovet:setLuukkuAuki(luukkuAuki, noEventSend)
    SetOviEvent.sendEvent(self, luukkuAuki, noEventSend);
    self.luukku = luukkuAuki;
end;


