--
-- AllradV3
-- Specialization for Allrad
--
-- V2 by modelleicher & Made by Case_IH_MxU135 | FIX and V3 by DragonLord2007/modhoster
-- www.schwabenmodding.bplaced.net
-- MP Fhig!


AllradV3 = {};

function AllradV3.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AllradV3:load(xmlFile)

    self.allradState = AllradV3.allradState;

    self.AllradV3Active = false;
	 
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudAllradPosX = 0.02;
    self.hudAllradWidth = 0.08;
    self.hudAllradPosY = 0.02;
    self.hudAllradHeight = 0.08;
	
	self.infoPanelAllradONPath = Utils.getFilename("texturen/AllradON.png", self.baseDirectory);
	self.hudAllradONOverlay = Overlay:new("texturen/hudAllradOverlayON", self.infoPanelAllradONPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	self.infoPanelAllradOFFPath = Utils.getFilename("texturen/AllradOFF.png", self.baseDirectory);
	self.hudAllradOFFOverlay = Overlay:new("texturen/hudAllradOverlayOFF", self.infoPanelAllradOFFPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	
	self.showhudAllrad = false;

end;

function AllradV3:delete()
    if self.hudAllradONOverlay ~= nil or self.hudAllradOFFOverlay ~= nil then
		self.hudAllradONOverlay:delete();
		self.hudAllradOFFOverlay:delete();		
	end;
end;

function AllradV3:readStream(streamId, connection)  
     self:allradState(streamReadBool(streamId), true);  
end;

function AllradV3:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.AllradV3Active);  
end;

function AllradV3:mouseEvent(posX, posY, isDown, isUp, button)
end;
function AllradV3:keyEvent(unicode, sym, modifier, isDown)
end;

function AllradV3:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV3Active = state;
end;

function AllradV3:update(dt)
    if self:getIsActiveForInput() then  
		if InputBinding.hasEvent(InputBinding.AllradV3) then
		   	self.AllradV3Active = not self.AllradV3Active;
		end;
    end;	
	if self:getIsActive() then	
   		if self.AllradV3Active == true then
			self.showhudAllrad = true;		
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllrad = false;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	      local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
	      for i=1, self.wellenCount do
	         setRotation(self.Wellen[i], 0, 0, getRx);
	      end;
	    end;		
    end; 
end;

function AllradV3:draw()
   if self.showhudAllrad == true then
      	self.hudAllradONOverlay:render();
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradOFF"), InputBinding.AllradV3);	
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("AllradON"), InputBinding.AllradV3);		
	    self.hudAllradOFFOverlay:render();
   end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;

