
-- by modelleicher
--

DammannAllrad = {};

function DammannAllrad.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function DammannAllrad:load(xmlFile)


		 
		 self.Allrad = false
		 
		 
	-- Allradwelle --
	self.GelenkF = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.GelenkF#index"));
    self.Welle = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.Welle#index"));    

	self.RotPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Allradwelle.RotPoint#index"));

		 
		 	
	
	-- Allrad Symbol--
	
	self.hudallrad_yesPosX = 0.85;
    self.hudallrad_yesWidth = 0.1;
    self.hudallrad_yesPosY = 0.2;
    self.hudallrad_yesHeight = 0.1;

	self.infoPanelAllradPath = Utils.getFilename("allrad_symb_yes.png", self.baseDirectory);
	self.hudallrad_yesOverlay = Overlay:new("hudallrad_yesOverlay", self.infoPanelAllradPath, self.hudallrad_yesPosX, self.hudallrad_yesPosY, self.hudallrad_yesWidth, self.hudallrad_yesHeight);

	self.showHudallrad_yes = false;

				 
end;

function DammannAllrad:delete()

	  -- Allradsymbol --
    if self.hudallradyesOverlay ~= nil then
		self.hudallrad_yesOverlay:delete();
	end;
end;

function DammannAllrad:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DammannAllrad:keyEvent(unicode, sym, modifier, isDown)
end;

function DammannAllrad:update(dt)

    if self:getIsActiveForInput() and self.isEntered then
    		
		if InputBinding.hasEvent(InputBinding.ALLRADDT2600H) then
		   	if self.Allrad == false then
		   	   self.Allrad = true
		   	else
		   		self.Allrad = false
		   	end;
		end;

		
   		-- Allrad Symbol Status --
   		if self.Allrad == true then
					self.showHudallrad_yes = true
					else
					self.showHudallrad_yes = false
		end;
   		
		
		-- autoRotateBackSpeed -- Automatisches Zurckdrehen ausschalten --
		if self.steeringlocked == false then
		   self.autoRotateBackSpeed	= 2.5
		end;
		
		if self.steeringlocked == true then
		   self.autoRotateBackSpeed = 0.0
		end;

		-- Allrad -- driveMode 2 = Allrad , driveMode 0 = kein Antrieb --
		if self.Allrad == true then
		 	self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2
			self.wheels[5].driveMode =2
		 	self.wheels[6].driveMode =2
		else
		 	self.wheels[1].driveMode =0
		 	self.wheels[2].driveMode =0
		 	self.wheels[3].driveMode =1
		 	self.wheels[4].driveMode =1
			self.wheels[5].driveMode =0
		 	self.wheels[6].driveMode =0
		end;
		
	   -- Allradwelle --
	   if self.Allrad == true then
	   self.PointRot = getRotation(self.RotPoint)

       setRotation(self.GelenkF,0 ,0 ,self.PointRot);
       setRotation(self.Welle,0 ,0 ,self.PointRot);
	   end;
	   				
	end;			 

end;

function DammannAllrad:draw()
		
  	if self.showHudallrad_yes and self.isEntered then
		self.hudallrad_yesOverlay:render();
	end;

end;

