--
-- MapFruitTrigger
--
-- M@D Author  Headshot XXL
-- M@D date 20.09.2009
--

print("Map: FruitTrigger loaded");

MapFruitTrigger = {};
MapFruitTrigger.fruitTrigger = {};

_G.MapFruitTriggerOnCreate = function(id)
	--print("created manure trigger, id: ", id);
	MapFruitTrigger:triggerLoad(id);
end;

function MapFruitTrigger:triggerLoad(id)
	
    addTrigger(id, "fruitTriggerCallback", self);
	
	local entry = {};	
	local fruitType = getUserAttribute(id, "fruitType");		
	local key = "FRUITTYPE_"..string.upper(fruitType);
	entry.fillType = FruitUtil[key];
	entry.fillSpeed = getUserAttribute(id, "fillSpeed");
	entry.id = id;	
	table.insert(self.fruitTrigger, entry);

	self.trailerInTrigger = 0;	
	self.fruitTriggerId = 0;
	
	self.fill = false;
	self.printText = false;

end;


function MapFruitTrigger:loadMap(name)
end;

function MapFruitTrigger:deleteMap()
end;

function MapFruitTrigger:delete()
end;

function MapFruitTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapFruitTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function MapFruitTrigger:update(dt)

	if self.trailerInTrigger ~= 0 then	
		
		if InputBinding.hasEvent(InputBinding.MAPFRUITTRIGGER_FILL)  then
			self.fill = not self.fill; 
		end; 
		if self.fill and self.printText then
			g_currentMission:addExtraPrintText(g_i18n:getText("MAPFRUITTRIGGER_1").. " " ..InputBinding.getButtonKeyName(InputBinding.MAPFRUITTRIGGER_FILL)); 
		elseif self.printText then
			g_currentMission:addExtraPrintText(g_i18n:getText("MAPFRUITTRIGGER_2").. " " ..InputBinding.getButtonKeyName(InputBinding.MAPFRUITTRIGGER_FILL)); 
		end; 
		
		self.printText = false;
		for i=1, table.getn(self.fruitTrigger) do
			if self.fruitTrigger[i].id == self.fruitTriggerId then				
				local attachable = g_currentMission.objectToTrailer[self.trailerInTrigger];
				if attachable ~= nil then
					if attachable.fillTypes ~= nil and attachable.setFillLevel ~= nil and attachable.fillLevel ~= nil then
						if self.fruitTrigger[i].fillType == attachable.currentFillType or attachable.currentFillType == FruitUtil.FRUITTYPE_UNKNOWN then
							if attachable.fillLevel < attachable.capacity and attachable:allowFillType(self.fruitTrigger[i].fillType, true) then
								if self.fill then
									local deltaFillLevel = dt*self.fruitTrigger[i].fillSpeed;
									attachable:setFillLevel(attachable.fillLevel+deltaFillLevel, self.fruitTrigger[i].fillType);
								end;
								self.printText = true;
							else
								self.fill = false;
							end;
						end;
					end;
				end;
			end;			
		end;
	else
		self.fill = false;
	end;
	
end;

function MapFruitTrigger:draw()
end;

function MapFruitTrigger:fruitTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

    if onEnter then
		if otherId ~= nil then			
			self.trailerInTrigger = otherId;
			self.fruitTriggerId = triggerId;		
		end;		
	elseif onLeave then
		self.trailerInTrigger = 0;
		self.fruitTriggerId = 0;
	elseif onStay then
		if otherId ~= nil then			
			self.trailerInTrigger = otherId;
			self.fruitTriggerId = triggerId;		
		end;
	end;
	
end;

addModEventListener(MapFruitTrigger);

