sts_zp5_005 = {};

function sts_zp5_005.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function sts_zp5_005:load(xmlFile)
  -- Rozdruzovaci valce
  self.rozdruzovaciValce = {};
  local i = 0;
  while true do
    local key = string.format("vehicle.rozdruzovaciValce.rozdruzovaciValec(%d)", i);
    if not hasXMLProperty(xmlFile, key) then
      break;
    end;
    local rozdruzovaciValec = {};
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
    if node ~= nil then
      rozdruzovaciValec.node = node;
      rozdruzovaciValec.otackyZaSekundu = Utils.degToRad(360*Utils.getNoNil(getXMLFloat(xmlFile, key.."#otackyZaSekundu"), 0.2));
      local x, y, z = getRotation(node);
      rozdruzovaciValec.curRotation = {x, y, z};
      table.insert(self.rozdruzovaciValce, rozdruzovaciValec);
    end;
    i = i + 1;
  end;

  -- Dopravniky, podlahovy a pricny
  self.dopravniky = {};
  local i = 0;
  while true do
    local key = string.format("vehicle.dopravniky.dopravnik(%d)", i);
    if not hasXMLProperty(xmlFile, key) then
      break;
    end;
    local dopravnik = {};
    local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
    if node ~= nil then
      dopravnik.node = node;
      dopravnik.otackyZaSekundu = Utils.degToRad(360*Utils.getNoNil(getXMLFloat(xmlFile, key.."#otackyZaSekundu"), 0.5));
      dopravnik.osaRotace = Utils.getNoNil(getXMLInt(xmlFile, key.."#osaRotace"),2 );
      table.insert(self.dopravniky, dopravnik);
    end;
    i = i + 1;
  end;
  self.vykladani = false;
end;

function sts_zp5_005:delete()
end;

function sts_zp5_005:mouseEvent(posX, posY, isDown, isUp, button)
end;

function sts_zp5_005:keyEvent(unicode, sym, modifier, isDown)
end;

function sts_zp5_005:update(dt)
  if self.isClient then
    self.vykladani = self.tipState == Trailer.TIPSTATE_OPENING or self.tipState == Trailer.TIPSTATE_OPEN;
    local pohyb = 0;
    if self.vykladani then
      for k,v in pairs(self.rozdruzovaciValce) do
        v.curRotation[1]=v.curRotation[1]+((dt/1000)*v.otackyZaSekundu);
        setRotation(v.node, unpack(v.curRotation));
        local x, y, z = getRotation(v.node);
        v.curRotation = {x, y, z};
      end;
      pohyb = 1;
    end;
    for k,v in pairs(self.dopravniky) do
      local o = (v.otackyZaSekundu) * pohyb;
      if v.osaRotace == 1 then
        setShaderParameter(v.node, "UVPlaySpeed", o, 0, 0, 0, false);
      elseif v.osaRotace == 2 then
        setShaderParameter(v.node, "UVPlaySpeed", 0, o, 0, 0, false);
      elseif v.osaRotace == 3 then
        setShaderParameter(v.node, "UVPlaySpeed", 0, 0, o, 0, false);
      end;
    end;
  end;
end;

function sts_zp5_005:draw()
end;


function sts_zp5_005:onAttach(attacherVehicle)
end;

function sts_zp5_005:onDetach()
end;