--
-- physicalCamera
-- Specialization for physically adapting Camera
--
-- @author  Knagsted
-- @date  16/07/10
--

-- Do not edit without my permission
--
physicalCamera = {};

function physicalCamera.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function physicalCamera:load(xmlFile)
	self.cameraRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cameraRotNode#index"));
	self.seatNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seatNode#index"));
	self.farmerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#index"));
	
	if self.cameraRotNode ~=nil then
		local x,y,z = getTranslation(self.cameraRotNode);
		self.startXTranslation = x;
		self.startYTranslation = y;
		self.startZTranslation = z;
	end;
	
	if self.seatNode ~=nil then
		local x,y,z = getTranslation(self.seatNode);
		self.startSeatXTranslation = x;
		self.startSeatYTranslation = y;
		self.startSeatZTranslation = z;
	end;

	if self.farmerNode ~=nil then
		local x,y,z = getTranslation(self.farmerNode);
		self.startFarmerXTranslation = x;
		self.startFarmerYTranslation = y;
		self.startFarmerZTranslation = z;
	end;
	
	--Sounds
	SeatSoundFile = Utils.getFilename("seatSound.wav", self.baseDirectory);
    self.SeatSoundId = createSample("SeatSound");
    loadSample(self.SeatSoundId, SeatSoundFile, false);
    self.SeatPlaying = false;
	self.SeatSoundOffset = getSampleDuration(self.SeatSoundId);
	
	self.maxTranslationPrCycle = 0.00008;
	self.offsetTranslation = 0;
	self.offsetAdjustmentTranslation = 0;
	
	if self.wheels[1].repr ~= nil and self.wheels[1].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[1].repr);
		local x2,y2,z2 = getTranslation(self.wheels[2].repr);

		self.averageYTranslation = (y + y2)/2;
	end;
	
	self.camTranslation = self.averageYTranslation;
	
end;

function physicalCamera:delete()
	if self.SeatPlaying ~= nil then
		stopSample(self.SeatSoundId);
	end;
end;

function physicalCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function physicalCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function physicalCamera:update(dt)
	if self.wheels[1].repr ~= nil and self.wheels[1].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[1].repr);
		local x2,y2,z2 = getTranslation(self.wheels[2].repr);

		self.averageYTranslation = (y + y2)/2;
	end;
	
	--renderText(0.5, 0.65, 0.040, string.format(self.averageYTranslation));
	
	self.playSeatSound = false;
	if self.camTranslation > self.averageYTranslation then
		self.camTranslation = self.camTranslation - self.maxTranslationPrCycle * dt;
		if self.camTranslation < self.averageYTranslation then
			self.camTranslation = self.averageYTranslation;
		end;
	elseif self.camTranslation < self.averageYTranslation then
		self.camTranslation = self.camTranslation + self.maxTranslationPrCycle * dt;
		if self.camTranslation > self.averageYTranslation then
			self.camTranslation = self.averageYTranslation;
		end;
		--set sound to play if seat damping is very big.
		if self.camTranslation < self.averageYTranslation - 0.0002 and self.isEntered then
			self.playSeatSound = true;
		end;
	end;
	
	--renderText(0.5, 0.75, 0.040, string.format(self.camTranslation));
	
	if self.cameraRotNode ~= nil then
		setTranslation(self.cameraRotNode, self.startXTranslation, self.camTranslation+self.offsetAdjustmentTranslation, self.startZTranslation);
	end;
	
	--setup offsetAdjustmentTranslation accoding to weight on tractor
	if self.currentWeight ~= nil then
		self.offsetAdjustmentTranslation = -self.currentWeight * 0.000425;
	else
		self.offsetAdjustmentTranslation = -0.82;
	end;
	
	self.offsetTranslation = self.camTranslation - self.startYTranslation;
	
	local adjustedOffsetTranslation = (self.offsetTranslation)+self.offsetAdjustmentTranslation;
	
	if self.seatNode ~= nil then
		setTranslation(self.seatNode, self.startSeatXTranslation, self.startSeatYTranslation + adjustedOffsetTranslation, self.startSeatZTranslation);
	end;
	
	if self.farmerNode ~= nil then
		setTranslation(self.farmerNode, self.startFarmerXTranslation, self.startFarmerYTranslation+adjustedOffsetTranslation, self.startFarmerZTranslation);
	end;
	
	if self.seatNode ~= nil then
		if self.playSeatSound then
			if not self.SeatPlaying then
				playSample(self.SeatSoundId, 0, 1, 0);
				self.SeatPlaying = true;
			end;
		else
			if self.SeatPlaying then
				stopSample(self.SeatSoundId);
				self.SeatPlaying = false;
			end;
		end;
	end;
end;

function physicalCamera:onLeave()
end;

function physicalCamera:draw()
end;

