
-- KNAGSTED
JD8820 = {};

function JD8820.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD8820:load(xmlFile)
    self.lastGrainLevel = 0;
    self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;

    self.grainTankAuger = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.grainTankAuger#index"));
    self.grainTankAugerRotation = 0;

    self.pipeGrainParticleSystem = {};
    self.pipeGrainParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeGrainParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeGrainParticleSystem, "vehicle.pipeGrainParticleSystem", self.pipeGrainParticleSystemindex, false, nil, self.baseDirectory);
    
    self.pipeRapeParticleSystem = {};
    self.pipeRapeParticleSystemindex = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pipeRapeParticleSystem#index"));
    Utils.loadParticleSystem(xmlFile, self.pipeRapeParticleSystem, "vehicle.pipeRapeParticleSystem", self.pipeRapeParticleSystemindex, false, nil, self.baseDirectory);

    self.strawSpreaderAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strawSpreader#count"),0);
    self.strawSpreader = {};
    for i=1, self.strawSpreaderAnz do
        local objname = string.format("vehicle.strawSpreader.strawSpreader" .. "%d",i);
        self.strawSpreader[i] = {};
        self.strawSpreader[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.strawSpreader[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
    end;

    local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;

	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.rotationPartDrehzahl1 = {};
        self.rotationPartDrehzahl1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#minRot"));
        self.rotationPartDrehzahl1.minRot = {};
        self.rotationPartDrehzahl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#maxRot"));
        self.rotationPartDrehzahl1.maxRot = {};
        self.rotationPartDrehzahl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#rotTime"), 2)*1000;
        self.rotationPartDrehzahl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl1#touchRotLimit"), 10));
    end;

	local rotationPartNodeDrehzahl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#index"));
    if rotationPartNodeDrehzahl2 ~= nil then
        self.rotationPartDrehzahl2 = {};
        self.rotationPartDrehzahl2.node = rotationPartNodeDrehzahl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#minRot"));
        self.rotationPartDrehzahl2.minRot = {};
        self.rotationPartDrehzahl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#maxRot"));
        self.rotationPartDrehzahl2.maxRot = {};
        self.rotationPartDrehzahl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartDrehzahl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartDrehzahl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartDrehzahl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#rotTime"), 2)*1000;
        self.rotationPartDrehzahl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartDrehzahl2#touchRotLimit"), 10));
    end;


	self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;


	self.lowLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lowLightDisplay#index"));
	self.farLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.farLightDisplay#index"));
	self.workLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.workLightDisplay#index"));
	self.fuelWarningDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fuelWarningDisplay#index"));
	self.handbrakeDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakeDisplay#index"));
	self.barDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.barDisplay#index"));
	self.roundLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.roundLightDisplay#index"));

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

    self.gearShifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter#index"));
    self.hydroStat = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydroStat#index"));
    self.leftLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftLifter#index"));
    self.rightLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightLifter#index"));

	self.frontleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontleuchten#count"),0);
    self.frontleuchtenKey = getXMLString(xmlFile, "vehicle.frontleuchten#key");
    self.frontleuchtenAn = false;
    self.frontleuchten = {};
    for i=1, self.frontleuchtenAnz do
        local objname = string.format("vehicle.frontleuchten.light" .. "%d",i);
        self.frontleuchten[i] = {};
        self.frontleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.frontleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.frontleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.frontleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.frontleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.frontleuchten[i].emit and self.frontleuchten[i].source ~= nil then
           setVisibility(self.frontleuchten[i].source, false);
        end;
    end;

      self.leuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.leuchten#count"),0);
    self.leuchtenKey = getXMLString(xmlFile, "vehicle.leuchten#key");
    self.leuchtenAn = false;
    self.leuchten = {};
    for i=1, self.leuchtenAnz do
        local objname = string.format("vehicle.leuchten.light" .. "%d",i);
        self.leuchten[i] = {};
        self.leuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.leuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.leuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.leuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.leuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.leuchten[i].emit and self.leuchten[i].source ~= nil then
           setVisibility(self.leuchten[i].source, false);
        end;
    end;

	self.worklightsActive = false;
	self.fuelWarnlightsActive = false;


end;

function JD8820:delete()
end;

function JD8820:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD8820:keyEvent(unicode, sym, modifier, isDown)
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;

    if self.isEntered then
      if self.frontleuchtenKey ~= nil then
         if isDown and sym == Input[self.frontleuchtenKey] then
            if self.leuchtenAn == false and self.frontleuchtenAn == false and self.farleuchtenAn == false then
           		self.leuchtenAn = true;
			self.frontleuchtenAn = true;
		elseif self.frontleuchtenAn == true then
			self.frontleuchtenAn = false;
			self.farleuchtenAn = true;
		elseif self.farleuchtenAn == true then
			self.farleuchtenAn = false;
			self.leuchtenAn = false;
		end;
         end;
      end;
   end;

   if self.isEntered then
         for i=1, self.leuchtenAnz do
           setVisibility(self.leuchten[i].light, self.leuchtenAn);
         end;
    end;

   if self.isEntered then
         for i=1, self.frontleuchtenAnz do
           setVisibility(self.frontleuchten[i].light, self.frontleuchtenAn);
         end;
    end;

end;

function JD8820:update(dt)
	if self.isHired or self.isEntered then
	   if self.motor.lastMotorRpm > 0.01 then
		self.fanRotation = self.fanRotation + 10;
		setRotation(self.fan, Utils.degToRad(self.fanRotation), 0, 0);
	   end;
	end;

	local procent = self.grainTankFillLevel/self.grainTankCapacity*100;
	if procent >= 89 then
		if not self.rundumleuchtenAn then
			self.rundumleuchtenAn = true;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
	end;

	for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
			--if self.strawEmitState or self.chopperActivated then
			if self.lastGrainLevel < self.grainTankFillLevel then 
				if self.currentGrainTankFruitType == FruitUtil.FRUITTYPE_RAPE then
					Utils.setEmittingState(self.pipeRapeParticleSystem, true);
				else
					Utils.setEmittingState(self.pipeGrainParticleSystem, true);
				end;
			else
			  	Utils.setEmittingState(self.pipeGrainParticleSystem, false);
				Utils.setEmittingState(self.pipeRapeParticleSystem, false);
			end;
			self.lastGrainLevel = self.grainTankFillLevel;
			
			self.grainTankAugerRotation = self.grainTankAugerRotation - 25;
			setRotation(self.grainTankAuger, 0, Utils.degToRad(self.grainTankAugerRotation), 0);
		    else 
			Utils.setEmittingState(self.pipeGrainParticleSystem, false);
			Utils.setEmittingState(self.pipeRapeParticleSystem, false);
		    end;
	end;

	 if self.chopperActivated then
        if self.strawSpreaderAnz > 0 then
            for i=1, self.strawSpreaderAnz do
              rotate(self.strawSpreader[i].rotNode, 0, dt*self.strawSpreader[i].speed, 0);
            end;
        end;
	end;

		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;
	
		if self.rotationPartTanknadel2 ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel2.node);
			y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
			setRotation(self.rotationPartTanknadel2.node, x, y ,z);
		end;

		if self.isEntered then
		  if self.rundumleuchtenAn == true then
			setVisibility(self.roundLightDisplay, true);
		  else
			setVisibility(self.roundLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.frontleuchtenAn == true then
			setVisibility(self.lowLightDisplay, true);
		  else
			setVisibility(self.lowLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.farleuchtenAn == true then
			setVisibility(self.farLightDisplay, true);
		  else
			setVisibility(self.farLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.leuchtenAn == true then
			setVisibility(self.lightDisplay, true);
		  else
			setVisibility(self.lightDisplay, false);
	    	  end;
    		end;

	if self.isEntered or self.isHired then
        if self.rundumleuchtenAnz > 0 then
          if self.rundumleuchtenAn then
            for i=1, self.rundumleuchtenAnz do
              rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
            end;
          end;
        end;
      end;

	local speed = self.lastSpeed*3600;
	if self.gearShifter ~= nil then
		if self.movingDirection < 0 then
			setRotation(self.gearShifter, Utils.degToRad(-8.673), Utils.degToRad(4.336), Utils.degToRad(4.805));
  
		else	
		if speed >= -0.5 and speed < 0.5 then
			setRotation(self.gearShifter, Utils.degToRad(-23.328), Utils.degToRad(5.284), Utils.degToRad(12.055));
		elseif speed >= 0.5 and speed < 2 then
			setRotation(self.gearShifter, Utils.degToRad(-22.025), Utils.degToRad(7.809), Utils.degToRad(13.667));
		elseif speed >= 2 and speed < 7 then
			setRotation(self.gearShifter, Utils.degToRad(-16.899), Utils.degToRad(7.809), Utils.degToRad(13.8));
		elseif speed >= 7 and speed < 15 then
			setRotation(self.gearShifter, Utils.degToRad(-11.528), Utils.degToRad(7.809), Utils.degToRad(14));
		elseif speed >= 15 and speed < 25 then
			setRotation(self.gearShifter, Utils.degToRad(-4), Utils.degToRad(7.809), Utils.degToRad(14.3));
		elseif speed >= 25 and speed < 30 then
			setRotation(self.gearShifter, Utils.degToRad(1.495), Utils.degToRad(7.785), Utils.degToRad(14.608));
		elseif speed >= 30 then			
			setRotation(self.gearShifter, Utils.degToRad(7.885), Utils.degToRad(7.596), Utils.degToRad(16.004));
		end;
		end;
	end;

	if self.isEntered then
		if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
			setVisibility(self.workLightDisplay, self.worklightsActive); 
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
			setVisibility(self.workLightDisplay, false);
		end;
	end;

	local maxDrehzahl = 2200;
	if self.rotationPartDrehzahl1 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl1.node);
		y = ((self.rotationPartDrehzahl1.maxRot[2] - self.rotationPartDrehzahl1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl1.minRot[2];
		setRotation(self.rotationPartDrehzahl1.node, x, y ,z);
	end;
	if self.rotationPartDrehzahl2 ~= nil then
		local x, y, z = getRotation(self.rotationPartDrehzahl2.node);
		y = ((self.rotationPartDrehzahl2.maxRot[2] - self.rotationPartDrehzahl2.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartDrehzahl2.minRot[2];
		setRotation(self.rotationPartDrehzahl2.node, x, y ,z);
	end;

end;

function JD8820:draw()
end;

