--
-- fertilizerTrailer
-- Specialization for fertilizerTrailer
--
-- @author Felix "Outlaw" Sorge
-- @date  20/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--


fertilizerTrailer = {};

function fertilizerTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function fertilizerTrailer:load(xmlFile)

	self.fertilizerInRange = SpecializationUtil.callSpecializationsFunction("fertilizerInRange");
	self.fertilizerTanker = true;	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.fillTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
    if chargeTypes ~= nil then
		self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
        local types = Utils.splitString(" ", chargeTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.chargeTypes[desc.index] = true;
            end;
        end;
    end;
		
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
    end;

	
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	self.keyName = "Taste";	
		
	
end;


function fertilizerTrailer:update(dt)
							
   	self.inRange = false; 
    local nearestDistance = 10.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);

		if distance < nearestDistance then
			local attachable = g_currentMission.attachables[i];			
			
			
				if fruitType == self.currentFillType and attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
				             
					if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
						self.turnOn = false; 
						if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = false;
						end;
					elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0  then
					     

						if self.turnOn then

							g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.fertilizerTrailer_ON).. ": " ..g_i18n:getText("fertilizerTrailer_2")); 
							if InputBinding.hasEvent(InputBinding.fertilizerTrailer_ON) then
								self.turnOn = not self.turnOn; 
								if self.workSoundEnabled then
									stopSample(self.workSound);
									self.workSoundEnabled = false;
								end;
							end;
														
						else

							g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.fertilizerTrailer_ON).. ": " ..g_i18n:getText("fertilizerTrailer_1")); 
							if InputBinding.hasEvent(InputBinding.fertilizerTrailer_ON)  then
								self.turnOn = not self.turnOn; 
								if not self.workSoundEnabled then
								     playSample(self.workSound, 0, 1, 0);
									self.workSoundEnabled = true;   
								end; 
			
							end;
						end;
						
						
						
					
						if self.turnOn then
							self.inRange = true; 
							local deltaLevel = self.literPerSecond*dt/1000.0;
							deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
							self.fillLevel = self.fillLevel-deltaLevel;
							self:setFillLevel(self.fillLevel, self.currentFillType);
							attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);	
						end; 	
								
							
						
					end; 
				end;
			end;
		end;
   
		
	if not self.inRange and self.turnOn and self.workSoundEnabled then
		if self.workSoundEnabled then
			self.turnOn = not self.turnOn; 
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
	
	

end;


function fertilizerTrailer:fertilizerInRange(dt)

end;


function fertilizerTrailer:delete()
end;


function fertilizerTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;


function fertilizerTrailer:keyEvent(unicode, sym, modifier, isDown)

end;


function fertilizerTrailer:draw()
end;


function fertilizerTrailer:onAttach()
end; 	


function fertilizerTrailer:onDetach()
end;