--
-- Kockschaufel Animation Script
--
-- M@D Author:  Heady
-- M@D date: 17.04.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Kockschaufel = {};

function Kockschaufel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Kockschaufel:load(xmlFile)

	self.moveDirection1 = 0;
	local rootNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	self.animCharSet1 = 0;
	if rootNode1 ~= nil then
		self.animCharSet1 = getAnimCharacterSet(rootNode1);
		if self.animCharSet1 ~= 0 then
			local clip = getAnimClipIndex(self.animCharSet1, getXMLString(xmlFile, "vehicle.animation#animationClip"));
			assignAnimTrackClip(self.animCharSet1, 0, clip);
			setAnimTrackLoopState(self.animCharSet1, 0, false);
			self.speedScale1 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#speedScale"), 1);
			self.animDuration1 = getAnimClipDuration(self.animCharSet1, clip);
		end;
	end;

end;


function Kockschaufel:delete()

end;

function Kockschaufel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kockschaufel:keyEvent(unicode, sym, modifier, isDown)
end;

function Kockschaufel:readStream(streamId, connection)
	-- client read on syncronization --
	
	setAnimTrackTime(self.animCharSet1, 0, streamReadFloat32(streamId));
	
end;

function Kockschaufel:writeStream(streamId, connection)
	-- server write to client on syncronization --
	
	streamWriteFloat32(streamId, getAnimTrackTime(self.animCharSet1, 0));

end;

function Kockschaufel:update(dt)

	local moveDirection1 = self.moveDirection1;

	if self:getIsActiveForInput() then
		self.moveDirection1 = 0;
		if InputBinding.isPressed(InputBinding.KOCK_OPEN) then
			self.moveDirection1 = 1;
		elseif InputBinding.isPressed(InputBinding.KOCK_CLOSE) then
			self.moveDirection1 = -1;
		end;
    end;
	
	if moveDirection1 ~= self.moveDirection1 then
		MPEvent:updateSendEvent(self);
	end;
	
	if self:getIsActive() then
	
		if self.animCharSet1 ~= 0 then
			local speedScale = nil;
			if self.moveDirection1 > 0.1 then
				speedScale = self.speedScale1;
			elseif self.moveDirection1 < -0.1 then
				speedScale = -self.speedScale1;
			end;
			if speedScale ~= nil then
				local animTrackTime = getAnimTrackTime(self.animCharSet1, 0);
				if speedScale > 0 then
					if animTrackTime < 0.0 then
						setAnimTrackTime(self.animCharSet1, 0, 0.0);
					elseif animTrackTime > self.animDuration1 then
						self.implementFallOut = true;
					end;
				else
					if animTrackTime > self.animDuration1 then
						setAnimTrackTime(self.animCharSet1, 0, self.animDuration1);
					elseif animTrackTime < 0.0 then
						self.implementFallOut = false;
					end;
				end;
				setAnimTrackSpeedScale(self.animCharSet1, 0, speedScale);
				enableAnimTrack(self.animCharSet1, 0);
				
				for i, jointDesc in pairs(self.componentJoints) do
				   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
				end;
			else
				disableAnimTrack(self.animCharSet1, 0);
			end;
		end;
		
	end;

end;

function Kockschaufel:draw()

	g_currentMission:addExtraPrintText(g_i18n:getText("KOCK_1"));

end;

function Kockschaufel:onDetach()
    if self.deactivateOnDetach then
        Kockschaufel.onDeactivate(self);
    end;
end;

function Kockschaufel:onLeave()
    if self.deactivateOnLeave then
        Kockschaufel.onDeactivate(self);
    end;
end;

function Kockschaufel:onDeactivate()

	if self.animCharSet1 ~= 0 then
		disableAnimTrack(self.animCharSet1, 0);
	end;

end;

