-- by modelleicher
-- Setzt das rotLimit eines componentJoints (Achse) auf einen bestimmten wert bei aktivieren des Dreschwerkes und wieder auf 0 bei deaktivieren.
-- sorgt ausserdem dafr dass die Rder immer geradestehen...

HangWorkTransport = {};

function HangWorkTransport.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function HangWorkTransport:load(xmlFile)
	self.jointNumber = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Hangmodus.joint#number" ), nil);
	self.jointMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Hangmodus.joint#maxRot"), 10);
	self.jointCloseTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Hangmodus.joint#closeTime"), 1);
	
	self.lwIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hangmodus.wheels#leftIndex"));
	self.lwRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hangmodus.wheels#leftReference"));
	self.rwIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hangmodus.wheels#rightIndex"));
	self.rwRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Hangmodus.wheels#rightReference"));
	
	self.workMode = false;
	self.currentRot = 0;
end;

function HangWorkTransport:delete()
end;
function HangWorkTransport:readStream(streamId, connection)
end;
function HangWorkTransport:writeStream(streamId, connection)
end;
function HangWorkTransport:mouseEvent(posX, posY, isDown, isUp, button)
end;
function HangWorkTransport:keyEvent(unicode, sym, modifier, isDown)
end;

function HangWorkTransport:startThreshing()
	self.workMode = true;
end;
function HangWorkTransport:stopThreshing()
	self.workMode = false;
end;

function HangWorkTransport:update(dt)	
	if self:getIsActive() then			
		if self.workMode == true then
		    setJointRotationLimit(self.componentJoints[self.jointNumber].jointIndex, 2, true, Utils.degToRad(-self.jointMaxRot), Utils.degToRad(self.jointMaxRot));
			self.currentRot = self.jointMaxRot								
		end;
		if self.workMode == false then
		    if self.currentRot > 0.5 then
			    local speed = 0.1*self.jointCloseTime
				self.currentRot = self.currentRot - speed
				setJointRotationLimit(self.componentJoints[self.jointNumber].jointIndex, 2, true, Utils.degToRad(-self.currentRot), Utils.degToRad(self.currentRot));			
			else
				setJointRotationLimit(self.componentJoints[self.jointNumber].jointIndex, 2, true, Utils.degToRad(-0), Utils.degToRad(0));			
			end;				
		end;
	end;
end;

function HangWorkTransport:updateTick(dt)
	if self:getIsActive() then
		-- Ausrichtung des linken Rades
		local px, py, pz = getWorldTranslation(self.lwRef); 
		local bx, by, bz = getWorldTranslation(self.lwIndex);
		local dx = px - bx;
		local dy = py - by;
		local dz = pz - bz;
		local ux, uy, uz = localDirectionToWorld(self.lwRef, 0, 1, 0);
		dx, dy, dz = worldDirectionToLocal(getParent(self.lwIndex), dx, dy, dz);
		ux, uy, uz = worldDirectionToLocal(getParent(self.lwIndex), ux, uy, uz);
		setDirection(self.lwIndex, dx, dy, dz, ux, uy, uz);	
		-- Ausrichtung des rechten Rades
		local px2, py2, pz2 = getWorldTranslation(self.rwRef); 
		local bx2, by2, bz2 = getWorldTranslation(self.rwIndex);
		local dx2 = px2 - bx2;
		local dy2 = py2 - by2;
		local dz2 = pz2 - bz2;
		local ux2, uy2, uz2 = localDirectionToWorld(self.rwRef, 0, 1, 0);
		dx2, dy2, dz2 = worldDirectionToLocal(getParent(self.rwIndex), dx2, dy2, dz2);
		ux2, uy2, uz2 = worldDirectionToLocal(getParent(self.rwIndex), ux2, uy2, uz2);
		setDirection(self.rwIndex, dx2, dy2, dz2, ux2, uy2, uz2);	
	end;
end;
function HangWorkTransport:draw()
end;


