VariableTrailerEvent = {};
VariableTrailerEvent_mt = Class(VariableTrailerEvent, Event);

InitEventClass(VariableTrailerEvent, "VariableTrailerEvent");

function VariableTrailerEvent:emptyNew()
    local self = Event:new(VariableTrailerEvent_mt);
    self.className="VariableTrailerEvent";
    return self;
end;

function VariableTrailerEvent:new(vehicle, state)
    local self = VariableTrailerEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function VariableTrailerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function VariableTrailerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
end;

function VariableTrailerEvent:run(connection)
	--print("VariableTrailerEvent:run(connection)...");
	--if self.vehicle ~= nil then
		--print("self.state="..self.state.." self.vehicle="..tostring(self.vehicle));
	
		self.vehicle:setActiveTrailer(self.state, true);
		if not connection:getIsServer() then
			g_server:broadcastEvent(VariableTrailerEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
		end;
	--end;
end;

function VariableTrailerEvent.sendEvent(vehicle, state, noEventSend)
	--print("VariableTrailerEvent.sendEvent(vehicle, state, noEventSend)");
	if vehicle == nil then
		print("--------> VariableTrailerEvent erRoR :/ ");
	end;
    if state ~= vehicle.varTip.activeTrailerIdx then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(VariableTrailerEvent:new(vehicle, state), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(VariableTrailerEvent:new(vehicle, state));
            end;
        end;
	end;
end;

