GripperCameraActivState = {};
GripperCameraActivState_mt = Class(GripperCameraActivState, Event);

InitEventClass(GripperCameraActivState, "GripperCameraActivState");

function GripperCameraActivState:emptyNew()
    local self = Event:new(GripperCameraActivState_mt);
    self.className = "GripperCameraActivState";
    return self;
end;

function GripperCameraActivState:new(object, cameraActive)
    local self = GripperCameraActivState:emptyNew()
    self.object = object;
	self.cameraActive = cameraActive;
    return self;
end;

function GripperCameraActivState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.cameraActive = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function GripperCameraActivState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.cameraActive);
end;

function GripperCameraActivState:run(connection)
	self.object:setGripperCameraState(self.cameraActive);
    if not connection:getIsServer() then
        g_server:broadcastEvent(GripperCameraActivState:new(self.object, self.cameraActive), nil, connection, self.object);
    end;	
end;

function GripperCameraActivState.sendEvent(vehicle, cameraActive, noEventSend)
	if cameraActive ~= vehicle.gripperCameraActive then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(GripperCameraActivState:new(vehicle, cameraActive), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(GripperCameraActivState:new(vehicle, cameraActive));
			end;
		end;
	end;
end;

