--
-- CowsAndFields
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

CowsAndFields = {}

local CowsAndFields_mt = Class(CowsAndFields, Mission00);

function CowsAndFields:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = CowsAndFields_mt;
    end;
    local self = CowsAndFields:superClass():new(baseDirectory, mt);
    return self;
end;

function CowsAndFields:delete()
    CowsAndFields:superClass().delete(self);
end;

function CowsAndFields:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("elements/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    -- self:loadMap(Utils.getFilename("elements/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
	

	agravispic = Utils.getFilename("pda/agravis.png", self.baseDirectory);
	hofpic = Utils.getFilename("pda/home.png", self.baseDirectory);
	rfnordpic = Utils.getFilename("pda/rfNord.png", self.baseDirectory);
	blumenpic = Utils.getFilename("pda/Blume.png", self.baseDirectory);
	hafenpic = Utils.getFilename("pda/anchor.png", self.baseDirectory);
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Farming Shop", "dataS2/missions/hud_pda_spot_shop.png", 870, 635, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 809, 1499, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Lighthouse", "dataS2/missions/hud_pda_spot_lighthouse.png", 114, 1929, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 459, 718, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Bell", "dataS2/missions/hud_pda_spot_bell.png", 519, 149, 0.055, 0.036, false, false, 0);

		-- create Map Hotspots
    self.missionPDA:createMapHotspot("RFNord", rfnordpic, 411, 1689, 0.055, 0.036, false, false, 0);
	
		-- create Map Hotspots
    self.missionPDA:createMapHotspot("RFAgravis", agravispic, 1385, 858, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Dairy", "dataS2/missions/hud_pda_spot_dairy.png", 1471, 752, 0.055, 0.036, false, false, 0);

	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1208, 236, 0.055, 0.036, false, false, 0);
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("home", hofpic, 1132, 1750, 0.055, 0.036, false, false, 0);
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("gaertnerei", blumenpic, 672, 1762, 0.055, 0.036, false, false, 0);
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Hafen", hafenpic, 352, 1303, 0.055, 0.036, false, false, 0);
	
	if not g_currentMission.missionInfo.isValid then
	-- this is a new savegame, so change the number of cows
	g_currentMission.missionInfo.numCows = 10;
	end;
    
    CowsAndFields:superClass().load(self);
end
function CowsAndFields:loadFinished()
    CowsAndFields:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function CowsAndFields:mouseEvent(posX, posY, isDown, isUp, button)
    CowsAndFields:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function CowsAndFields:keyEvent(unicode, sym, modifier, isDown)
    CowsAndFields:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function CowsAndFields:update(dt)
    CowsAndFields:superClass().update(self, dt);
end;

function CowsAndFields:draw()
    CowsAndFields:superClass().draw(self);
end;