--
-- Compas for Steerable
--
-- @author  Decker    (ls-uk.info, Decker_MMIV)
-- @date    2011-03-12
--
-- @edit    v0.9(beta)  Public release
--          v1.0        Changed to overload 'Steerable', particular needed for the Lexion 770 combine.
--          -"-         Detect if old-version is still loaded, then display a text on screen.
--

Compas = {};
Compas.showOnHud = true;
Compas.hudX = 0.870;
Compas.hudY = 0.855;
Compas.hudOverlay = Overlay:new("hudOverlay", Utils.getFilename("PDA/Compas_hud.dds", g_currentModDirectory), Compas.hudX, Compas.hudY, 0.12, 0.039);

function Compas:loadMap(name)
    self.oldVersionDetected = false;
    local mods = Utils.getNoNil(g_currentMission.loadingScreen.mods, g_currentMission.loadingScreen.missionDynamicInfo.mods);
    if mods ~= nil then
        for k,v in pairs(mods) do
            if (   v.fileHash == "a5dba174b2df43b59800ef0ee675d882"
                or v.modName  == "CompasForAITractorAICombine") then
                self.oldVersionDetected = true;
                break;
            end;
        end;
    --  else
    --      print("Unable to look through mods-array.");
    end;
end;

function Compas:deleteMap()
end;

function Compas:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Compas:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_c and bitAND(modifier, Input.MOD_ALT) > 0 then
        Compas.showOnHud = not Compas.showOnHud;
	end;
end;

function Compas:update(dt)
end;

function Compas:draw()
    if self.oldVersionDetected then
        -- Display notice about removing the old/previous version of this mod.
        setTextAlignment(RenderText.ALIGN_CENTER);
        setTextColor(1.0, 0.4, 0.4, 1.0);
        renderText(0.5, 0.95, 0.03, g_i18n:getText("OldVersionDetected"));
        -- Normalise text-styling, because other mods expect it this way.
        setTextAlignment(RenderText.ALIGN_LEFT);
        setTextColor(1,1,1,1);
    end;
end;

addModEventListener(Compas);


--
--
--
function DrawCompas(self)
    if self:getIsActiveForInput() then
        local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
        local length = Utils.vector2Length(x,z);
        if (length ~= 0.0) then -- Try to make sure we do not divide by zero.
            local direction = math.deg(math.atan2(z/length,x/length)) + 90.0;   -- Rotate clockwise, so north=0, east=90, south=180, west=270.
            while (direction > 359.999999) do
                direction = direction - 360.0;
            end;
            while (direction < 0.0) do
                direction = direction + 360.0;
            end;

            local dirText = "";

            --  if     (direction >= 360-22.5 or  direction <   0+22.5) then  dirText = g_i18n:getText("north");       --"N";
            --  elseif (direction >=  45-22.5 and direction <  45+22.5) then  dirText = g_i18n:getText("northeast");   --"NE";
            --  elseif (direction >=  90-22.5 and direction <  90+22.5) then  dirText = g_i18n:getText("east");        --"E";
            --  elseif (direction >= 135-22.5 and direction < 135+22.5) then  dirText = g_i18n:getText("southeast");   --"SE";
            --  elseif (direction >= 180-22.5 and direction < 180+22.5) then  dirText = g_i18n:getText("south");       --"S";
            --  elseif (direction >= 225-22.5 and direction < 225+22.5) then  dirText = g_i18n:getText("southwest");   --"SW";
            --  elseif (direction >= 270-22.5 and direction < 270+22.5) then  dirText = g_i18n:getText("west");        --"W";
            --  elseif (direction >= 315-22.5 and direction < 315+22.5) then  dirText = g_i18n:getText("northwest");   --"NW";
            --  end;

            if     (direction >= 337.5    or  direction <  22.5   ) then  dirText = g_i18n:getText("north");       --"N";
            elseif (direction >=  22.5    and direction <  67.5   ) then  dirText = g_i18n:getText("northeast");   --"NE";
            elseif (direction >=  67.5    and direction < 112.5   ) then  dirText = g_i18n:getText("east");        --"E";
            elseif (direction >= 112.5    and direction < 157.5   ) then  dirText = g_i18n:getText("southeast");   --"SE";
            elseif (direction >= 157.5    and direction < 202.5   ) then  dirText = g_i18n:getText("south");       --"S";
            elseif (direction >= 202.5    and direction < 247.5   ) then  dirText = g_i18n:getText("southwest");   --"SW";
            elseif (direction >= 247.5    and direction < 292.5   ) then  dirText = g_i18n:getText("west");        --"W";
            elseif (direction >= 292.5    and direction < 337.5   ) then  dirText = g_i18n:getText("northwest");   --"NW";
            end;

            dirText = dirText .. string.format(" %6.2f", direction);
            Compas.hudOverlay:render();
            setTextAlignment(RenderText.ALIGN_RIGHT);
            setTextBold(true);
            setTextColor(0,0,0,1); renderText(Compas.hudX+0.105, Compas.hudY+0.007, 0.022, dirText);  -- Black shadow-text
            setTextColor(1,1,1,1); renderText(Compas.hudX+0.105, Compas.hudY+0.009, 0.022, dirText);  -- White text

            -- Normalise text-styling, because other mods expect it this way.
            setTextAlignment(RenderText.ALIGN_LEFT);
            setTextBold(false);
        end;
    end;
end;

--
--
--
local origSteerableDraw = Steerable.draw;
Steerable.draw = function(self)
    if origSteerableDraw ~= nil then
        origSteerableDraw(self);
    end;
    if Compas.showOnHud then
        DrawCompas(self);
    end;
end;
