-- Zylinder
-- Spezi fr einfache Hydraulikzylinder oder Zylinder aller Arten
-- Ebenfalls sind einfache setDirections mglich

-- by modelleicher
-- www.schwabenmodding.bplaced.net


zylinder = {};

function zylinder.prerequisitesPresent(specializations)
    return true;
end;

function zylinder:load(xmlFile)
	self.zylinderCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Zylinder#count"), 0);
	self.zylinder = {};	
	if self.zylinderCount ~= 0 then
		for i=1, self.zylinderCount do
			local zyl = {};
			local path = string.format("vehicle.Zylinder.Zylinder%d", i);
			zyl.dir1 = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#dir1"));
			zyl.dir2 = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#dir2"));
			table.insert(self.zylinder, zyl);
		end;
	end;
	
	self.directionsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Directions#count"), 0);
	self.directions = {};
	if self.directionsCount ~= 0 then
		for i=1, self.directionsCount do
			local dir = {};
			local path = string.format("vehicle.Directions.Direction%d", i);
			dir.index = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));
			dir.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#ref"));
			dir.doScaleBool = Utils.getNoNil(getXMLBool(xmlFile, path .. "#doScaleBool"));
			if dir.doScaleBool == true then
				dir.scaleRef = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#scaleRef"));			
				ax, ay, az = getWorldTranslation(dir.index);
				bx, by, bz = getWorldTranslation(dir.scaleRef);
				dir.scaleDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
			end;
			table.insert(self.directions, dir);
		end;
	end;

end;

function zylinder:delete()
end;
function zylinder:mouseEvent(posX, posY, isDown, isUp, button)
end;
function zylinder:keyEvent(unicode, sym, modifier, isDown)
end;
function zylinder:update(dt)	
	if self:getIsActive() then	
		if self.zylinderCount ~= 0 and self.zylinderCount ~= nil then
			for i=1, self.zylinderCount do
				if self.zylinder[i].dir1 ~= nil and self.zylinder[i].dir2 ~= nil then
				local ax, ay, az = getWorldTranslation(self.zylinder[i].dir1);
				local bx, by, bz = getWorldTranslation(self.zylinder[i].dir2);
				x, y, z = worldDirectionToLocal(getParent(self.zylinder[i].dir1), bx-ax, by-ay, bz-az);
				setDirection(self.zylinder[i].dir1, x, y, z, 0, 1, 0);
				local ax2, ay2, az2 = getWorldTranslation(self.zylinder[i].dir2);
				local bx2, by2, bz2 = getWorldTranslation(self.zylinder[i].dir1);
				x2, y2, z2 = worldDirectionToLocal(getParent(self.zylinder[i].dir2), bx2-ax2, by2-ay2, bz2-az2);
				setDirection(self.zylinder[i].dir2, x2, y2, z2, 0, 1, 0); 
				end;
			end;
		end;
		if self.directionsCount ~= 0 and self.directionsCount ~= nil then
			for i=1, self.directionsCount do
				if self.directions[i].index ~= nil and self.directions[i].ref ~= nil then
					local ax, ay, az = getWorldTranslation(self.directions[i].index);
					local bx, by, bz = getWorldTranslation(self.directions[i].ref);
					x, y, z = worldDirectionToLocal(getParent(self.directions[i].index), bx-ax, by-ay, bz-az);
					setDirection(self.directions[i].index, x, y, z, 0, 1, 0);
					if self.directions[i].doScaleBool == true and self.directions[i].scaleRef ~= nil then
						local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
						local scaleX, scaleY, scaleZ = getScale(self.directions[i].index);
						local setScaleWert = scaleZ * (distance / self.directions[i].scaleDistance);
						setScale(self.directions[i].index, 1, 1, setScaleWert);
					end;
				end;
			end;
		end;
    end; 
end;

function zylinder:draw()
end;
