--
-- allradwelleAnimationCounty
-- Specialization for Driveshaft Animation at a County Super Six
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- Diese Spezi ist speziell fr den County angepasst auf zwei Allradwellen und zwei setDirection Teile fr diese Wellen.
-- This Specialization is done expecially for the county and his double driveshafts.


allradwelleAnimationCounty = {};

function allradwelleAnimationCounty.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function allradwelleAnimationCounty:load(xmlFile)

	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen#count"), 0);	 
	self.Wellen = {};
	self.Speed = {};
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
			local welleTB = {};
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    welleTB.index = Utils.indexToObject(self.components, getXMLString(xmlFile, Welle .. "#index"));
			welleTB.speed = Utils.getNoNil(getXMLFloat(xmlFile, Welle .. "#speed"));
			table.insert(self.Wellen, welleTB);
	    end;
	end;
	
	-- Optionale Ausrichtung der Welle auf die Vorderachse, nur bei Pendelachsen erforderlich /load the driveshaft-direction indices
	self.dwelle1 = {};
	self.dwelle2 = {};
	self.dwelle1.dir1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Allradwellen.SetDirection.welle1#dir1"));
	self.dwelle1.dir2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Allradwellen.SetDirection.welle1#dir2"));
	self.dwelle2.dir1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Allradwellen.SetDirection.welle2#dir1"));
	self.dwelle2.dir2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Allradwellen.SetDirection.welle2#dir2"));
	
end;

function allradwelleAnimationCounty:delete()
end;
function allradwelleAnimationCounty:mouseEvent(posX, posY, isDown, isUp, button)
end;
function allradwelleAnimationCounty:keyEvent(unicode, sym, modifier, isDown)
end;
function allradwelleAnimationCounty:update(dt)	
	if self:getIsActive() then	
		-- Rotationsbewegung der Allradwellen /rotation of the driveshafts
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
		  local getRx, getRy, getRz = getRotation(self.wheels[3].repr);			
	      for i=1, self.wellenCount do
	        setRotation(self.Wellen[i].index, 0, 0, getRx * self.Wellen[i].speed);
	      end;
	    end;	
		
		-- Ausrichtung der Allradwellen auf die Vorderachse (Nur bei Pendelachsen erforderlich) /setDirection of the driveshafts--
		if self.dwelle1.dir1 ~= nil and self.dwelle1.dir2 ~= nil then
			local ax, ay, az = getWorldTranslation(self.dwelle1.dir1);
			local bx, by, bz = getWorldTranslation(self.dwelle1.dir2);
			x, y, z = worldDirectionToLocal(getParent(self.dwelle1.dir1), bx-ax, by-ay, bz-az);
			setDirection(self.dwelle1.dir1, x, y, z, 0, 1, 0);
			local ax2, ay2, az2 = getWorldTranslation(self.dwelle1.dir2);
			local bx2, by2, bz2 = getWorldTranslation(self.dwelle1.dir1);
			x2, y2, z2 = worldDirectionToLocal(getParent(self.dwelle1.dir2), bx2-ax2, by2-ay2, bz2-az2);
			setDirection(self.dwelle1.dir2, x2, y2, z2, 0, 1, 0);
		end;
		if self.dwelle2.dir1 ~= nil and self.dwelle2.dir2 ~= nil then
			local ax, ay, az = getWorldTranslation(self.dwelle2.dir1);
			local bx, by, bz = getWorldTranslation(self.dwelle2.dir2);
			x, y, z = worldDirectionToLocal(getParent(self.dwelle2.dir1), bx-ax, by-ay, bz-az);
			setDirection(self.dwelle2.dir1, x, y, z, 0, 1, 0);
			local ax2, ay2, az2 = getWorldTranslation(self.dwelle2.dir2);
			local bx2, by2, bz2 = getWorldTranslation(self.dwelle2.dir1);
			x2, y2, z2 = worldDirectionToLocal(getParent(self.dwelle2.dir2), bx2-ax2, by2-ay2, bz2-az2);
			setDirection(self.dwelle2.dir2, x2, y2, z2, 0, 1, 0);	
		end;	
    end; 
end;

function allradwelleAnimationCounty:draw()
end;
