--
-- workLights
-- Specialization for workLights.
--
-- @author  Templaer
-- @date  25/04/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

workLights = {};

function workLights.prerequisitesPresent(specializations)
    return true;
end;

function workLights:load(xmlFile)
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.workLights.workLight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsOn = false;
end;

function workLights:delete()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsOn = false;
end;

function workLights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function workLights:keyEvent(unicode, sym, modifier, isDown)
end;

function workLights:update(dt)

	if self:getIsActive() and self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.workLightsOn = not self.workLightsOn;
		end;
	
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsOn);
		end;
	end;

end;

function workLights:onLeave()
end;

function workLights:draw()
if self.iworkLightsOn then
	g_currentMission:addExtraPrintText(g_i18n:getText("ON"),InputBinding.Hobein_Plane);
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("OFF"),InputBinding.Hobein_Plane);
	end;
end;

