--
-- 
-- 
--
-- @author Acid_Burn84

--
-- Copyright (C) by Acid_Burn84

Tieflader = {};

function Tieflader.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Tieflader:load(xmlFile)

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
end;

function Tieflader:delete()
end;

function Tieflader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tieflader:keyEvent(unicode, sym, modifier, isDown)
	 
	if isDown and sym == Input.KEY_r then
		self.rundumleuchtenAn = not self.rundumleuchtenAn;
		for i=1, self.rundumleuchtenAnz do
		 setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
		end;
	end;
  
end;


function Tieflader:update(dt)
   
	if self.attacherVehicle ~= nil then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;
   
end;

function Tieflader:draw()

end;

function Tieflader:onDetach()
	self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
end;
